import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { EmbeddedProcessFormChannelApiImpl } from "./EmbeddedProcessFormChannelApiImpl";
import { init } from "../envelope";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
export const EmbeddedProcessForm = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
            targetOrigin: props.targetOrigin,
        });
        return envelopeServer.envelopeApi.requests.processForm__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, Object.assign({}, props.processDefinition));
    }, []);
    return (React.createElement(EmbeddedProcessFormEnvelope, { ref: forwardedRef, apiImpl: new EmbeddedProcessFormChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedProcessFormEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedProcessForm.js.map