var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState } from "react";
import { Dropdown, DropdownItem, KebabToggle, DropdownPosition, DropdownToggle, DropdownToggleCheckbox, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Toolbar, ToolbarItem, ToolbarContent, ToolbarFilter, ToolbarToggleGroup, ToolbarGroup, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { OverflowMenu, OverflowMenuContent, OverflowMenuControl, OverflowMenuItem, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import "../styles.css";
import { formatForBulkListProcessInstance } from "../utils/ProcessListUtils";
import { ProcessInstanceState, } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { BulkListType, } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
var Category;
(function (Category) {
    Category["STATUS"] = "Status";
    Category["BUSINESS_KEY"] = "Business key";
})(Category || (Category = {}));
var BulkSelectionType;
(function (BulkSelectionType) {
    BulkSelectionType["NONE"] = "NONE";
    BulkSelectionType["PARENT"] = "PARENT";
    BulkSelectionType["PARENT_CHILD"] = "PARENT_CHILD";
})(BulkSelectionType || (BulkSelectionType = {}));
const ProcessListToolbar = ({ filters, setFilters, applyFilter, refresh, processStates, setProcessStates, selectedInstances, setSelectedInstances, processInstances, setProcessInstances, isAllChecked, setIsAllChecked, driver, defaultStatusFilter, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [businessKeyInput, setBusinessKeyInput] = useState("");
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [operationType, setOperationType] = useState();
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [isCheckboxDropdownOpen, setisCheckboxDropdownOpen] = useState(false);
    const [operationResults, setOperationResults] = useState({
        ABORT: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        SKIP: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        RETRY: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
    });
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const operations = {
        ABORT: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.ABORT],
            messages: {
                successMessage: `Aborted ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were aborted`,
                warningMessage: !processStates.includes(ProcessInstanceState.Aborted)
                    ? `Note: The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} status has been updated. The list may appear inconsistent until you refresh any applied filters.`
                    : "",
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were already completed or aborted.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state === ProcessInstanceState.Aborted || instance.state === ProcessInstanceState.Completed) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleProcessMultipleAction(remainingInstances, OperationType.ABORT).then((result) => {
                        onShowMessage("Abort operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.ABORT);
                        processInstances.forEach((instance) => {
                            result.successProcessInstances.forEach((successInstances) => {
                                if (successInstances.id === instance.id) {
                                    instance.state = ProcessInstanceState.Aborted;
                                }
                            });
                        });
                        setProcessInstances([...processInstances]);
                    });
                }),
            },
        },
        SKIP: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.SKIP],
            messages: {
                successMessage: `Skipped ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were skipped`,
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were not in error state.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state !== ProcessInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleProcessMultipleAction(remainingInstances, OperationType.SKIP).then((result) => {
                        onShowMessage("Skip operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.SKIP);
                    });
                }),
            },
        },
        RETRY: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.RETRY],
            messages: {
                successMessage: `Retriggered ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were retriggered`,
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were not in error state.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance["state"] !== ProcessInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleProcessMultipleAction(remainingInstances, OperationType.RETRY).then((result) => {
                        onShowMessage("Retry operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.RETRY);
                    });
                }),
            },
        },
    };
    const onShowMessage = (title, successItems, failedItems, ignoredItems, operation) => {
        setModalTitle(title);
        setTitleType("success");
        setOperationType(operation);
        setOperationResults(Object.assign(Object.assign({}, operationResults), { [operation]: Object.assign(Object.assign({}, operationResults[operation]), { successItems: formatForBulkListProcessInstance(successItems), failedItems: formatForBulkListProcessInstance(failedItems), ignoredItems: formatForBulkListProcessInstance(ignoredItems) }) }));
        handleModalToggle();
    };
    const checkboxDropdownToggle = () => {
        setisCheckboxDropdownOpen(!isCheckboxDropdownOpen);
    };
    const onStatusToggle = (isExpandedItem) => {
        setIsExpanded(isExpandedItem);
    };
    const onProcessManagementButtonSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onProcessManagementKebabToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const onSelect = (event, selection) => {
        if (processStates.includes(selection)) {
            const newProcessStates = [...processStates].filter((state) => state !== selection);
            setProcessStates(newProcessStates);
        }
        else {
            setProcessStates([...processStates, selection]);
        }
    };
    const onDeleteChip = (categoryName, value) => {
        var _a;
        const clonedProcessStates = [...processStates];
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        switch (categoryName) {
            case Category.STATUS:
                _.remove(clonedProcessStates, (status) => {
                    return status === value;
                });
                setProcessStates(clonedProcessStates);
                setFilters(Object.assign(Object.assign({}, filters), { status: clonedProcessStates }));
                break;
            case Category.BUSINESS_KEY:
                _.remove(clonedBusinessKeyArray, (businessKey) => {
                    return businessKey === value;
                });
                setFilters(Object.assign(Object.assign({}, filters), { businessKey: clonedBusinessKeyArray }));
                break;
        }
        applyFilter({
            status: clonedProcessStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onApplyFilter = () => {
        var _a;
        setBusinessKeyInput("");
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        if (businessKeyInput && !clonedBusinessKeyArray.includes(businessKeyInput)) {
            clonedBusinessKeyArray.push(businessKeyInput);
        }
        setFilters(Object.assign(Object.assign({}, filters), { status: processStates, businessKey: clonedBusinessKeyArray }));
        applyFilter({
            status: processStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            businessKeyInput.length > 0 && onApplyFilter();
        }
    };
    const resetAllFilters = () => {
        const defaultFilters = {
            status: defaultStatusFilter,
            businessKey: [],
        };
        setProcessStates(defaultFilters.status);
        setFilters(defaultFilters);
        applyFilter(defaultFilters);
    };
    const resetSelected = () => {
        const clonedProcessInstances = _.cloneDeep(processInstances);
        clonedProcessInstances.forEach((processInstance) => {
            var _a;
            processInstance.isSelected = false;
            if (!_.isEmpty(processInstance.childProcessInstances)) {
                (_a = processInstance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    childInstance.isSelected = false;
                });
            }
        });
        setProcessInstances(clonedProcessInstances);
        setSelectedInstances([]);
        setIsAllChecked(false);
    };
    const handleCheckboxSelectClick = (selection, isCheckBoxClicked) => {
        const clonedProcessInstances = [...processInstances];
        if (selection === BulkSelectionType.NONE) {
            clonedProcessInstances.forEach((instance) => {
                instance.isSelected = false;
                instance.childProcessInstances &&
                    instance.childProcessInstances.length > 0 &&
                    instance.childProcessInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances([]);
        }
        if (selection === BulkSelectionType.PARENT) {
            const tempSelectedInstances = [];
            clonedProcessInstances.forEach((instance) => {
                var _a;
                if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                    instance.isSelected = true;
                    tempSelectedInstances.push(instance);
                }
                instance.childProcessInstances &&
                    instance.childProcessInstances.length > 0 &&
                    instance.childProcessInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances(tempSelectedInstances);
        }
        if (selection === BulkSelectionType.PARENT_CHILD) {
            const tempSelectedInstances = [];
            if (isAllChecked && isCheckBoxClicked) {
                tempSelectedInstances.length = 0;
                clonedProcessInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                        instance.isSelected = false;
                    }
                    instance.childProcessInstances &&
                        instance.childProcessInstances.length > 0 &&
                        instance.childProcessInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = false;
                                }
                            }
                        });
                });
            }
            else {
                clonedProcessInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                        instance.isSelected = true;
                        tempSelectedInstances.push(instance);
                    }
                    instance.childProcessInstances &&
                        instance.childProcessInstances.length > 0 &&
                        instance.childProcessInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = true;
                                    tempSelectedInstances.push(childInstance);
                                }
                            }
                        });
                });
            }
            setSelectedInstances(tempSelectedInstances);
        }
        setProcessInstances(clonedProcessInstances);
    };
    const statusMenuItems = [
        React.createElement(SelectOption, { key: "ACTIVE", value: "ACTIVE" }),
        React.createElement(SelectOption, { key: "COMPLETED", value: "COMPLETED" }),
        React.createElement(SelectOption, { key: "ERROR", value: "ERROR" }),
        React.createElement(SelectOption, { key: "ABORTED", value: "ABORTED" }),
        React.createElement(SelectOption, { key: "SUSPENDED", value: "SUSPENDED" }),
    ];
    const checkboxItems = [
        React.createElement(DropdownItem, { key: "none", onClick: () => handleCheckboxSelectClick(BulkSelectionType.NONE, false), id: "none" }, "Select none"),
        React.createElement(DropdownItem, { key: "all-parent", onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT, false), id: "all-parent" }, "Select all parent processes"),
        React.createElement(DropdownItem, { key: "all-parent-child", onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, false), id: "all-parent-child" }, "Select all processes"),
    ];
    const dropdownItemsProcesManagementButtons = () => {
        return [
            React.createElement(DropdownItem, { "data-testid": "multi-abort", key: "abort", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0 }, "Abort selected"),
            React.createElement(DropdownItem, { "data-testid": "multi-skip", key: "skip", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0 }, "Skip selected"),
            React.createElement(DropdownItem, { "data-testid": "multi-retry", key: "retry", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0 }, "Retry selected"),
        ];
    };
    const buttonItems = (React.createElement(OverflowMenu, { breakpoint: "xl" },
        React.createElement(OverflowMenuContent, null,
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0 }, "Abort selected")),
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0 }, "Skip selected")),
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0 }, "Retry selected"))),
        React.createElement(OverflowMenuControl, null,
            React.createElement(Dropdown, { onSelect: onProcessManagementButtonSelect, toggle: React.createElement(KebabToggle, { onToggle: onProcessManagementKebabToggle }), isOpen: isKebabOpen, isPlain: true, dropdownItems: dropdownItemsProcesManagementButtons() }))));
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarItem, { variant: "bulk-select", id: "bulk-select" },
                React.createElement(Dropdown, { position: DropdownPosition.left, toggle: React.createElement(DropdownToggle, { isDisabled: filters.status.length === 0, onToggle: checkboxDropdownToggle, splitButtonItems: [
                            React.createElement(DropdownToggleCheckbox, { id: "select-all-checkbox", key: "split-checkbox", "aria-label": "Select all", isChecked: isAllChecked, onChange: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, true), isDisabled: filters.status.length === 0 }),
                        ] }, selectedInstances.length === 0 ? "" : selectedInstances.length + " selected"), dropdownItems: checkboxItems, isOpen: isCheckboxDropdownOpen })),
            React.createElement(ToolbarFilter, { chips: filters.status, deleteChip: onDeleteChip, className: "kogito-management-console__state-dropdown-list pf-u-mr-sm", categoryName: "Status", id: "datatoolbar-filter-status" },
                React.createElement(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: onStatusToggle, onSelect: onSelect, selections: processStates, isOpen: isExpanded, placeholderText: "Status", id: "status-select", "data-testid": "status-select" }, statusMenuItems)),
            React.createElement(ToolbarFilter, { chips: filters.businessKey, deleteChip: onDeleteChip, categoryName: Category.BUSINESS_KEY },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "businessKey", id: "businessKey", "data-testid": "businesskey", type: "search", "aria-label": "business key", onChange: setBusinessKeyInput, onKeyPress: onEnterClicked, placeholder: "Filter by business key", value: businessKeyInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { variant: "primary", onClick: onApplyFilter, "data-testid": "apply-filter-button" }, "Apply filter"))),
        React.createElement(ToolbarGroup, null,
            React.createElement(ToolbarItem, { variant: "separator" }),
            React.createElement(ToolbarGroup, { className: "pf-u-ml-md", id: "process-management-buttons" }, buttonItems))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: refresh, "data-testid": "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(React.Fragment, null,
        React.createElement(ProcessInfoModal, { modalTitle: setTitle(titleType, modalTitle), isModalOpen: isModalOpen, operationResult: operations[operationType], handleModalToggle: handleModalToggle, resetSelected: resetSelected, ouiaId: "operation-result" }),
        React.createElement(Toolbar, Object.assign({ "data-testid": "data-toolbar-with-filter", className: "pf-m-toggle-group-container kogito-management-console__state-dropdown-list", collapseListedFiltersBreakpoint: "xl", clearAllFilters: resetAllFilters, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "process-list-toolbar", ouiaSafe)),
            React.createElement(ToolbarContent, null, toolbarItems))));
};
export default ProcessListToolbar;
//# sourceMappingURL=ProcessListToolbar.js.map