import React, { useEffect, useState } from "react";
import { FormNotification } from "@kie-tools/runtime-tools-components/dist/components/FormNotification";
import { componentOuiaProps, ouiaPageTypeAndObjectId, } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Card, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { CloudEventFormContainer } from "../CloudEventFormContainer/CloudEventFormContainer";
export var CloudEventPageSource;
(function (CloudEventPageSource) {
    CloudEventPageSource["DEFINITIONS"] = "definitions";
    CloudEventPageSource["INSTANCES"] = "instances";
})(CloudEventPageSource || (CloudEventPageSource = {}));
export const CloudEventForm = ({ instanceId, isTriggerNewInstance, cloudEventSource, onStartWorkflowError, onTriggerCloudEventSuccess, onTriggerStartCloudEventSuccess, serviceUrl, ouiaId, ouiaSafe, }) => {
    const [notification, setNotification] = useState();
    useEffect(() => {
        return ouiaPageTypeAndObjectId("trigger-cloud-event-form");
    }, []);
    return (React.createElement(React.Fragment, null,
        React.createElement(PageSection, Object.assign({}, componentOuiaProps(`title${ouiaId ? "-" + ouiaId : ""}`, "trigger-cloud-event-form-page-section", ouiaSafe), { variant: "light" }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: TextVariants.h1 }, "Trigger Cloud Event")),
            notification && (React.createElement("div", null,
                React.createElement(FormNotification, { notification: notification })))),
        React.createElement(PageSection, Object.assign({}, componentOuiaProps(`content${ouiaId ? "-" + ouiaId : ""}`, "cloud-event-form-page-section", ouiaSafe)),
            React.createElement(Card, { className: "Dev-ui__card-size" },
                React.createElement(CardBody, { className: "pf-u-h-100" },
                    React.createElement(CloudEventFormContainer, { instanceId: instanceId, isTriggerNewInstance: isTriggerNewInstance, cloudEventSource: cloudEventSource, onStartWorkflowError: onStartWorkflowError, onTriggerCloudEventSuccess: onTriggerCloudEventSuccess, onTriggerStartCloudEventSuccess: onTriggerStartCloudEventSuccess, serviceUrl: serviceUrl }))))));
};
//# sourceMappingURL=CloudEventForm.js.map