export class WorkflowDefinitionListGatewayApiImpl {
    constructor(queries) {
        this.onOpenWorkflowListeners = [];
        this.onOpenTriggerCloudEventListeners = [];
        this.workflowDefinitionFilter = [];
        this.queries = queries;
    }
    getWorkflowDefinitionFilter() {
        return Promise.resolve(this.workflowDefinitionFilter);
    }
    setWorkflowDefinitionFilter(filter) {
        this.workflowDefinitionFilter = filter;
        return Promise.resolve();
    }
    openWorkflowForm(workflowDefinition) {
        this.onOpenWorkflowListeners.forEach((listener) => listener.onOpen(workflowDefinition));
        return Promise.resolve();
    }
    onOpenWorkflowFormListen(listener) {
        this.onOpenWorkflowListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenWorkflowListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenWorkflowListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    onOpenTriggerCloudEventListen(listener) {
        this.onOpenTriggerCloudEventListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenTriggerCloudEventListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenTriggerCloudEventListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    getWorkflowDefinitionsQuery() {
        return this.queries.getWorkflowDefinitions();
    }
    openTriggerCloudEvent(workflowDefinition) {
        this.onOpenTriggerCloudEventListeners.forEach((listener) => listener.onOpen(workflowDefinition));
        return Promise.resolve();
    }
}
//# sourceMappingURL=WorkflowDefinitionListGatewayApi.js.map