var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export class WorkflowListGatewayApiImpl {
    constructor(queries) {
        this.onOpenWorkflowListeners = [];
        this.onOpenTriggerCloudEventListeners = [];
        this.openWorkflow = (workflow) => {
            this.onOpenWorkflowListeners.forEach((listener) => listener.onOpen(workflow));
            return Promise.resolve();
        };
        this.initialLoad = (filter, sortBy) => {
            this._WorkflowListState.filters = filter;
            this._WorkflowListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this.workflowListState.filters = filter;
            return Promise.resolve();
        };
        this.applySorting = (sortBy) => {
            this._WorkflowListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.handleWorkflowSkip = (workflowInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleWorkflowSkip(workflowInstance);
        });
        this.handleWorkflowRetry = (workflowInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleWorkflowRetry(workflowInstance);
        });
        this.handleWorkflowAbort = (workflowInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleWorkflowAbort(workflowInstance);
        });
        this.handleWorkflowMultipleAction = (workflowInstances, operationType) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleWorkflowMultipleAction(workflowInstances, operationType);
        });
        this.queries = queries;
        this._WorkflowListState = {
            filters: {
                status: [],
                businessKey: [],
            },
            sortBy: {},
        };
    }
    get workflowListState() {
        return this._WorkflowListState;
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getWorkflowInstances(offset, limit, this._WorkflowListState.filters, this._WorkflowListState.sortBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    getChildWorkflowsQuery(rootWorkflowInstanceId) {
        return new Promise((resolve, reject) => {
            this.queries
                .getChildWorkflowInstances(rootWorkflowInstanceId)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenWorkflowListen(listener) {
        this.onOpenWorkflowListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenWorkflowListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenWorkflowListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    onOpenTriggerCloudEventListen(listener) {
        this.onOpenTriggerCloudEventListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenTriggerCloudEventListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenTriggerCloudEventListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    openTriggerCloudEvent(workflowInstance) {
        this.onOpenTriggerCloudEventListeners.forEach((listener) => listener.onOpen(workflowInstance));
    }
}
//# sourceMappingURL=WorkflowListGatewayApi.js.map