"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorHeader = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var atoms_1 = require("../atoms");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var DataDictionaryHandler_1 = require("../../DataDictionary/DataDictionaryHandler/DataDictionaryHandler");
var organisms_1 = require("../../Outputs/organisms");
var MiningSchemaHandler_1 = require("../../MiningSchema/MiningSchemaHandler/MiningSchemaHandler");
require("./EditorHeader.scss");
var isEditor = function (props) {
    return props.modelIndex !== undefined;
};
var EditorHeader = function (props) {
    var modelName = props.modelName, modelIndex = props.modelIndex;
    if (isEditor(props)) {
        var miningSchema = props.miningSchema, output = props.output, validateOutputFieldName = props.validateOutputFieldName, deleteOutputField = props.deleteOutputField, commitOutputField = props.commitOutputField, commitModelName = props.commitModelName;
        return ((0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, className: "editorHeader" }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ className: "editorHeader__modelName" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.ModelTitle, { modelName: modelName, commitModelName: commitModelName }) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { isFilled: true, "data-ouia-component-type": "filler" }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(DataDictionaryHandler_1.default, {}) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(MiningSchemaHandler_1.default, { miningSchema: miningSchema, modelIndex: modelIndex }) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(organisms_1.OutputsHandler, { modelIndex: modelIndex, output: output, miningSchema: miningSchema, validateOutputFieldName: validateOutputFieldName, deleteOutputField: deleteOutputField, commitOutputField: commitOutputField }) })] })));
    }
    else {
        return ((0, jsx_runtime_1.jsx)(Split_1.Split, __assign({ hasGutter: true, className: "editorHeader" }, { children: (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true, className: "editorHeader--modelName" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.ModelTitle, { modelName: modelName }) })) })));
    }
};
exports.EditorHeader = EditorHeader;
//# sourceMappingURL=EditorHeader.js.map