"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleEditorRouter = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_router_dom_1 = require("react-router-dom");
var templates_1 = require("../../EditorScorecard/templates");
var __1 = require("../../..");
var react_redux_1 = require("react-redux");
var _1 = require(".");
var templates_2 = require("../templates");
var EditorScorecard_1 = require("../../EditorScorecard");
var templates_3 = require("../../LinearRegressionViewer/templates");
var SingleEditorRouter = function (props) {
    var index = (0, react_router_dom_1.useParams)().index;
    var setActiveOperation = (0, EditorScorecard_1.useOperation)().setActiveOperation;
    var models = (0, react_redux_1.useSelector)(function (state) { return state.models; });
    if (!models) {
        return (0, jsx_runtime_1.jsx)(_1.EmptyStateModelNotFound, {});
    }
    var _index = index ? +index : -1;
    if (isNaN(_index) || _index < 0 || _index > models.length - 1) {
        return (0, jsx_runtime_1.jsx)(_1.EmptyStateModelNotFound, {});
    }
    var model = models[_index];
    var modelType = (0, __1.getModelType)(model);
    var _isSupportedModelType = (0, __1.isSupportedModelType)(model);
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ tabIndex: -1, onKeyDown: function (e) {
            if (e.key === "Escape") {
                setActiveOperation(EditorScorecard_1.Operation.NONE);
            }
        } }, { children: [!_isSupportedModelType && (0, jsx_runtime_1.jsx)(templates_2.UnsupportedModelPage, { path: props.path, model: model }), _isSupportedModelType && modelType === "Scorecard" && ((0, jsx_runtime_1.jsx)(templates_1.ScorecardEditorPage, { path: props.path, modelIndex: _index })), _isSupportedModelType && modelType === "Regression Model" && ((0, jsx_runtime_1.jsx)(templates_3.LinearRegressionViewerPage, { path: props.path, modelIndex: _index }))] })));
};
exports.SingleEditorRouter = SingleEditorRouter;
//# sourceMappingURL=SingleEditorRouter.js.map