"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicPredicateLabel = exports.CharacteristicLabel = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
require("./CharacteristicLabel.scss");
var atoms_1 = require("../../EditorCore/atoms");
var organisms_1 = require("../organisms");
var CharacteristicLabel = function (props) {
    var name = props.name, value = props.value;
    return ((0, jsx_runtime_1.jsxs)(Label_1.Label, __assign({ color: "cyan", className: "characteristic-list__item__label" }, { children: [(0, jsx_runtime_1.jsxs)("strong", { children: [name, ":"] }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: value })] })));
};
exports.CharacteristicLabel = CharacteristicLabel;
var CharacteristicPredicateLabel = function (predicate, dataFields, validations) {
    var value = (0, organisms_1.toText)(predicate, dataFields);
    var truncatedText = value.length > 32 ? value.slice(0, 29) + "..." : value;
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [value.length > truncatedText.length && ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ position: Tooltip_1.TooltipPosition.top, isContentLeftAligned: true, maxWidth: "100em", content: (0, jsx_runtime_1.jsx)("pre", { children: value }) }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: validations, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsx)("pre", { children: truncatedText }) }))), validations.length === 0 && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ tabIndex: 0, color: "blue", className: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsx)("pre", { children: truncatedText }) })))] }) }))), value.length === truncatedText.length && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)("span", __assign({ className: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: validations }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [predicate && (0, jsx_runtime_1.jsx)("pre", { children: value }), !predicate && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Predicate:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }))] }) })) }))), validations.length === 0 && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ tabIndex: 0, color: "blue", className: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsx)("pre", { children: value }) })))] }))] }));
};
exports.CharacteristicPredicateLabel = CharacteristicPredicateLabel;
//# sourceMappingURL=CharacteristicLabel.js.map