"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CorePropertiesTable = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var atoms_1 = require("../atoms");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var Level_1 = require("@patternfly/react-core/dist/js/layouts/Level");
var Switch_1 = require("@patternfly/react-core/dist/js/components/Switch");
require("./CorePropertiesTable.scss");
var Operation_1 = require("../Operation");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var lodash_1 = require("lodash");
var OperationContext_1 = require("../OperationContext");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var atoms_2 = require("../../EditorCore/atoms");
var set = Reflect.set;
var get = Reflect.get;
var GenericSelectorEditor = function (id, items, selection, onSelect, isDisabled) {
    return (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: id, items: items, selection: selection, onSelect: onSelect, isDisabled: isDisabled });
};
var CorePropertiesTable = function (props) {
    var _a = (0, OperationContext_1.useOperation)(), activeOperation = _a.activeOperation, setActiveOperation = _a.setActiveOperation;
    var _b = __read((0, react_1.useState)(false), 2), isEditing = _b[0], setEditing = _b[1];
    var _c = __read((0, react_1.useState)(), 2), isScorable = _c[0], setScorable = _c[1];
    var _d = __read((0, react_1.useState)(), 2), functionName = _d[0], setFunctionName = _d[1];
    var _e = __read((0, react_1.useState)(), 2), algorithmName = _e[0], setAlgorithmName = _e[1];
    var _f = __read((0, react_1.useState)(), 2), baselineScore = _f[0], setBaselineScore = _f[1];
    var _g = __read((0, react_1.useState)(), 2), baselineMethod = _g[0], setBaselineMethod = _g[1];
    var _h = __read((0, react_1.useState)(), 2), initialScore = _h[0], setInitialScore = _h[1];
    var _j = __read((0, react_1.useState)(), 2), areReasonCodesUsed = _j[0], setAreReasonCodesUsed = _j[1];
    var _k = __read((0, react_1.useState)(), 2), reasonCodeAlgorithm = _k[0], setReasonCodeAlgorithm = _k[1];
    (0, react_1.useEffect)(function () {
        setScorable(props.isScorable);
        setFunctionName(props.functionName);
        setAlgorithmName(props.algorithmName);
        setBaselineScore(props.baselineScore);
        setBaselineMethod(props.baselineMethod);
        setInitialScore(props.initialScore);
        setAreReasonCodesUsed(props.areReasonCodesUsed);
        setReasonCodeAlgorithm(props.reasonCodeAlgorithm);
    }, [props]);
    var ref = (0, react_cool_onclickoutside_1.default)(function () { return onCommitAndClose(); }, {
        disabled: activeOperation !== Operation_1.Operation.UPDATE_CORE,
        eventTypes: ["click"],
    });
    var toNumber = function (_value) {
        if (_value === "") {
            return undefined;
        }
        var n = Number(_value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    var toYesNo = function (_value) {
        return _value ? "Yes" : "No";
    };
    var onEdit = function (event) {
        event.preventDefault();
        event.stopPropagation();
        setActiveOperation(Operation_1.Operation.UPDATE_CORE);
        setEditing(true);
    };
    var onCommitAndClose = function () {
        onCommit({});
        onCancel();
    };
    var onCommit = function (partial) {
        var existingPartial = {};
        Object.keys(partial).forEach(function (key) { return set(existingPartial, key, get(props, key)); });
        if (!(0, lodash_1.isEqual)(partial, existingPartial)) {
            props.commit(__assign(__assign({}, props), partial));
        }
    };
    var onCancel = function () {
        setEditing(false);
        setActiveOperation(Operation_1.Operation.NONE);
    };
    var isEditModeEnabled = (0, react_1.useMemo)(function () { return isEditing && activeOperation === Operation_1.Operation.UPDATE_CORE; }, [isEditing, activeOperation]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var baselineScoreValidation = validationRegistry.get((0, paths_1.Builder)().forModel(props.modelIndex).forBaselineScore().build());
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [!isEditModeEnabled && ((0, jsx_runtime_1.jsx)("div", __assign({ tabIndex: 0, onClick: onEdit, onKeyDown: function (e) {
                    if (e.key === "Enter") {
                        onEdit(e);
                    }
                }, "data-testid": "core-properties-table" }, { children: (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light, className: "editable-item", "data-ouia-component-type": "model-setup-overview" }, { children: (0, jsx_runtime_1.jsx)(Stack_1.Stack, __assign({ hasGutter: true }, { children: (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ size: "lg", headingLevel: "h1" }, { children: "Model Setup" })) }), (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, { children: [isScorable !== undefined && CorePropertyLabel("Is Scorable", toYesNo(isScorable)), functionName !== undefined && CorePropertyLabel("Function", functionName), algorithmName !== undefined && CorePropertyLabel("Algorithm", algorithmName), initialScore !== undefined && CorePropertyLabel("Initial Score", initialScore), areReasonCodesUsed !== undefined &&
                                                CorePropertyLabel("Use Reason Codes", toYesNo(areReasonCodesUsed)), reasonCodeAlgorithm !== undefined &&
                                                CorePropertyLabel("Reason Code Algorithm", reasonCodeAlgorithm), baselineScore !== undefined &&
                                                baselineScoreValidation.length === 0 &&
                                                CorePropertyLabel("Baseline Score", baselineScore), baselineScoreValidation.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_2.ValidationIndicatorLabel, __assign({ validations: baselineScoreValidation, cssClass: "core-properties__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Baseline Score:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }) }))), baselineMethod !== undefined && CorePropertyLabel("Baseline Method", baselineMethod)] })] })) }) })) })) }))), isEditModeEnabled && ((0, jsx_runtime_1.jsx)("div", __assign({ ref: ref, "data-testid": "core-properties-table" }, { children: (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light, className: "editable-item--editing", "data-ouia-component-type": "edit-model-setup" }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Split_1.Split, __assign({ hasGutter: true }, { children: (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ size: "lg", headingLevel: "h1" }, { children: "Model Setup" })) }) })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, __assign({ onSubmit: function (e) {
                                        e.stopPropagation();
                                        e.preventDefault();
                                    }, className: "core-properties__container" }, { children: (0, jsx_runtime_1.jsxs)(Level_1.Level, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Is Scorable", fieldId: "core-isScorable" }, { children: (0, jsx_runtime_1.jsx)(Switch_1.Switch, { id: "core-isScorable", isChecked: isScorable === true, "aria-label": "Is scorable", "data-testid": "core-properties-table-isScorable", onChange: function (checked) {
                                                            setScorable(checked);
                                                            onCommit({ isScorable: checked });
                                                        }, ouiaId: "is-scorable" }) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Function", fieldId: "core-functionName", required: true }, { children: GenericSelectorEditor("core-functionName", [
                                                        "associationRules",
                                                        "sequences",
                                                        "classification",
                                                        "regression",
                                                        "clustering",
                                                        "timeSeries",
                                                        "mixed",
                                                    ], functionName, function (_selection) {
                                                        setFunctionName(_selection);
                                                        onCommit({ functionName: _selection });
                                                    }, true) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Algorithm", fieldId: "core-algorithmName" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "core-algorithmName", name: "core-algorithmName", "aria-describedby": "core-algorithmName", "data-testid": "core-properties-table-algorithmName", value: algorithmName !== null && algorithmName !== void 0 ? algorithmName : "", onChange: function (e) { return setAlgorithmName(e); }, onBlur: function () {
                                                            onCommit({
                                                                algorithmName: algorithmName === "" ? undefined : algorithmName,
                                                            });
                                                        }, ouiaId: "algorithm" }) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Initial score", fieldId: "core-initialScore" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { id: "core-initialScore", value: initialScore, onChange: function (e) { return setInitialScore(toNumber(e)); }, onBlur: function () {
                                                            onCommit({ initialScore: initialScore });
                                                        }, type: "number", ouiaId: "initial-score" }) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Use reason codes?", fieldId: "core-useReasonCodes" }, { children: (0, jsx_runtime_1.jsx)(Switch_1.Switch, { id: "core-useReasonCodes", isChecked: areReasonCodesUsed, "aria-label": "Use reason codes", "data-testid": "core-properties-table-useReasonCodes", onChange: function (checked) {
                                                            setAreReasonCodesUsed(checked);
                                                            onCommit({ areReasonCodesUsed: checked });
                                                        }, ouiaId: "use-reason-codes" }) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Reason code algorithm", fieldId: "core-reasonCodeAlgorithm" }, { children: GenericSelectorEditor("core-reasonCodeAlgorithm", ["pointsAbove", "pointsBelow"], reasonCodeAlgorithm, function (_selection) {
                                                        setReasonCodeAlgorithm(_selection);
                                                        onCommit({ reasonCodeAlgorithm: _selection });
                                                    }, !areReasonCodesUsed) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Baseline score", fieldId: "core-baselineScore", validated: baselineScoreValidation.length > 0 ? "warning" : "default", helperText: baselineScoreValidation.length > 0 ? baselineScoreValidation[0].message : undefined, labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: areReasonCodesUsed && props.isBaselineScoreDisabled
                                                            ? "A Baseline score is already provided inside all Characteristics"
                                                            : "\n                                When Use Reason Codes is set to yes, a Baseline score value must be provided.                                 Alternatively you can provide a Baseline score for all the characteristics\n                                " }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Baseline score", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { id: "core-baselineScore", value: baselineScore !== null && baselineScore !== void 0 ? baselineScore : "", onChange: function (e) { return setBaselineScore(toNumber(e)); }, onBlur: function () {
                                                            onCommit({ baselineScore: baselineScore });
                                                        }, type: "number", validated: baselineScoreValidation.length > 0 ? "warning" : "default", isDisabled: props.isBaselineScoreDisabled, ouiaId: "baseline-score" }) })) }), (0, jsx_runtime_1.jsx)(Level_1.LevelItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Baseline method", fieldId: "core-baselineMethod" }, { children: GenericSelectorEditor("core-baselineMethod", ["max", "min", "mean", "neutral", "other"], baselineMethod, function (_selection) {
                                                        setBaselineMethod(_selection);
                                                        onCommit({ baselineMethod: _selection });
                                                    }, !areReasonCodesUsed) })) })] })) })) })] })) })) })))] }));
};
exports.CorePropertiesTable = CorePropertiesTable;
var CorePropertyLabel = function (name, value) {
    return ((0, jsx_runtime_1.jsxs)(Label_1.Label, __assign({ color: "cyan", className: "core-properties__label", "data-ouia-component-type": "model-property" }, { children: [(0, jsx_runtime_1.jsxs)("strong", { children: [name, ":"] }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: value })] })));
};
//# sourceMappingURL=CorePropertiesTable.js.map