"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LandingPage = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var Gallery_1 = require("@patternfly/react-core/dist/js/layouts/Gallery");
var organisms_1 = require("../organisms");
var uuid_1 = require("uuid");
var react_redux_1 = require("react-redux");
var __1 = require("../../..");
var molecules_1 = require("../molecules");
var reducers_1 = require("../../../reducers");
var react_router_1 = require("react-router");
var history_1 = require("../../../history");
var LandingPage = function (props) {
    var history = (0, react_router_1.useHistory)();
    var _a = (0, history_1.useHistoryService)(), service = _a.service, getCurrentState = _a.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var _b = __read((0, react_1.useState)(""), 2), filter = _b[0], setFilter = _b[1];
    var _c = __read((0, react_1.useState)(true), 2), showUnsupportedModels = _c[0], setShowUnsupportedModels = _c[1];
    var models = (0, react_redux_1.useSelector)(function (state) { return state.models; });
    var hasUnsupportedModels = (0, react_1.useMemo)(function () { return (models !== null && models !== void 0 ? models : []).find(function (model) { return !(0, __1.isSupportedModelType)(model); }) !== undefined; }, [models]);
    var filterModels = (0, react_1.useCallback)(function () {
        var _lowerCaseFilter = filter.toLowerCase();
        var _filteredModels = models === null || models === void 0 ? void 0 : models.filter(function (_model) {
            var _modelName = (0, __1.getModelName)(_model);
            var _isSupportedModelType = (0, __1.isSupportedModelType)(_model);
            var _nameMatch = _modelName === undefined || _modelName.toLowerCase().includes(_lowerCaseFilter);
            var _supportMatch = showUnsupportedModels || _isSupportedModelType;
            return _nameMatch && _supportMatch;
        });
        return _filteredModels !== null && _filteredModels !== void 0 ? _filteredModels : [];
    }, [filter, showUnsupportedModels, models]);
    var filteredModels = (0, react_1.useMemo)(function () { return filterModels(); }, [filter, showUnsupportedModels, models]);
    var goToModel = (0, react_1.useCallback)(function (index) {
        history.push({
            pathname: "editor/" + index,
        });
    }, [history]);
    var onDelete = (0, react_1.useCallback)(function (index, modelName) {
        dispatch({
            type: reducers_1.Actions.DeleteModel,
            payload: {
                modelIndex: index,
            },
        });
    }, []);
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ "data-testid": "landing-page" }, { children: [(0, jsx_runtime_1.jsxs)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light }, { children: [(0, jsx_runtime_1.jsx)(molecules_1.LandingPageHeader, { title: props.path }), (0, jsx_runtime_1.jsx)(molecules_1.LandingPageToolbar, { onFilter: setFilter, hasUnsupportedModels: hasUnsupportedModels, showUnsupportedModels: showUnsupportedModels, onShowUnsupportedModels: setShowUnsupportedModels })] })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsxs)("section", { children: [filteredModels.length > 0 && ((0, jsx_runtime_1.jsx)(Gallery_1.Gallery, __assign({ hasGutter: true }, { children: filteredModels.map(function (model) {
                                var index = models === null || models === void 0 ? void 0 : models.indexOf(model);
                                var modelName = (0, __1.getModelName)(model);
                                var modelType = (0, __1.getModelType)(model);
                                return ((0, jsx_runtime_1.jsx)(Gallery_1.GalleryItem, __assign({ "data-testid": "landing-page__model-card" }, { children: (0, jsx_runtime_1.jsx)(molecules_1.ModelCard, { index: index, modelName: modelName, modelType: modelType, onClick: goToModel, onDelete: function (_index) { return onDelete(_index, modelName); } }) }), (0, uuid_1.v4)()));
                            }) }))), filteredModels.length === 0 && ((0, jsx_runtime_1.jsx)(organisms_1.EmptyStateNoModels, { createModel: function () {
                            } }))] }) }))] })));
};
exports.LandingPage = LandingPage;
//# sourceMappingURL=LandingPage.js.map