"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var uuid_1 = require("uuid");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Select_1 = require("@patternfly/react-core/dist/js/components/Select");
var MiningSchemaAddFields = function (_a) {
    var options = _a.options, onAdd = _a.onAdd, isDisabled = _a.isDisabled;
    var _b = __read((0, react_1.useState)(false), 2), isOpen = _b[0], setIsOpen = _b[1];
    var _c = __read((0, react_1.useState)([]), 2), selectOptions = _c[0], setSelectOptions = _c[1];
    var _d = __read((0, react_1.useState)([]), 2), selected = _d[0], setSelected = _d[1];
    var _e = __read((0, react_1.useState)((0, uuid_1.v4)()), 2), selectKey = _e[0], setSelectKey = _e[1];
    var onToggle = function (openStatus) {
        setIsOpen(openStatus);
    };
    var onSelect = function (event, selection) {
        if (selected.includes(selection.toString())) {
            var newSelections = selected.filter(function (item) { return item !== selection; });
            setSelected(newSelections);
        }
        else {
            setSelected(__spreadArray(__spreadArray([], __read(selected), false), [selection.toString()], false));
        }
    };
    var handleAdd = function () {
        onAdd(selected);
        clearSelection();
    };
    var addAllFields = function () {
        var availableOptions = selectOptions.filter(function (item) { return !item.disabled; });
        if (availableOptions.length) {
            onAdd(availableOptions.map(function (item) { return item.value; }));
        }
    };
    var clearSelection = function () {
        setSelected([]);
        setIsOpen(false);
    };
    (0, react_1.useEffect)(function () {
        setSelectOptions(options.map(function (option) { return ({
            value: option.name,
            disabled: option.isSelected,
        }); }));
        setSelectKey((0, uuid_1.v4)());
    }, [options]);
    return ((0, jsx_runtime_1.jsx)("section", __assign({ "data-ouia-component-id": "mining-toolbar" }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Select_1.Select, __assign({ variant: Select_1.SelectVariant.typeaheadMulti, typeAheadAriaLabel: "Select fields", onToggle: onToggle, toggleId: "select-mining-field", onSelect: onSelect, onClear: clearSelection, selections: selected, isOpen: isOpen, "aria-labelledby": "Select fields to add", placeholderText: "Select fields", isDisabled: isDisabled, ouiaId: "select-mining-field" }, { children: selectOptions.map(function (option, index) { return ((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { isDisabled: option.disabled, value: option.value, "data-ouia-component-id": option.value, "data-ouia-component-type": "select-option" }, index)); }) }), selectKey) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: handleAdd, isDisabled: isDisabled, ouiaId: "add-mining-field" }, { children: "Add Field(s)" })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: addAllFields, isDisabled: isDisabled, ouiaId: "add-all-fields" }, { children: "Add All Fields" })) })] })) })));
};
exports.default = MiningSchemaAddFields;
//# sourceMappingURL=MiningSchemaAddFields.js.map