"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var trash_icon_1 = require("@patternfly/react-icons/dist/js/icons/trash-icon");
var MiningSchemaContainer_1 = require("../MiningSchemaContainer/MiningSchemaContainer");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var MiningSchemaFieldLabels_1 = require("../MiningSchemaFieldLabels/MiningSchemaFieldLabels");
require("./MiningSchemaFields.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var MiningSchemaFields = function (_a) {
    var modelIndex = _a.modelIndex, dataDictionary = _a.dataDictionary, fields = _a.fields, onAddProperties = _a.onAddProperties, onDelete = _a.onDelete, onPropertyDelete = _a.onPropertyDelete, onEdit = _a.onEdit, onCancel = _a.onCancel;
    return ((0, jsx_runtime_1.jsx)("ul", __assign({ className: "mining-schema-list", "data-ouia-component-type": "mining-schema-list" }, { children: fields === null || fields === void 0 ? void 0 : fields.map(function (field, index) {
            return ((0, jsx_runtime_1.jsx)(MiningSchemaItem, { dataDictionary: dataDictionary, field: field, index: index, modelIndex: modelIndex, onAddProperties: onAddProperties, onDelete: onDelete, onPropertyDelete: onPropertyDelete, onEdit: onEdit, onCancel: onCancel }, field.name));
        }) })));
};
exports.default = MiningSchemaFields;
var MiningSchemaItem = function (props) {
    var index = props.index, modelIndex = props.modelIndex, dataDictionary = props.dataDictionary, field = props.field, onAddProperties = props.onAddProperties, onDelete = props.onDelete, onPropertyDelete = props.onPropertyDelete, onEdit = props.onEdit, onCancel = props.onCancel;
    var editing = (0, react_1.useContext)(MiningSchemaContainer_1.MiningSchemaContext);
    var ref = (0, react_cool_onclickoutside_1.default)(function () {
        onCancel();
    }, {
        disabled: editing !== index,
        eventTypes: ["click"],
    });
    var addProperties = function () {
        onAddProperties(index);
    };
    var deleteProperty = function (updatedField) {
        onPropertyDelete(index, updatedField);
    };
    var handleEdit = function (event) {
        event.preventDefault();
        event.stopPropagation();
        onEdit(index);
    };
    var handleDelete = function (event, interaction) {
        event.stopPropagation();
        event.preventDefault();
        if (onDelete) {
            onDelete(index, interaction);
        }
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).build()); }, [index, modelIndex, dataDictionary, field]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [index === editing && ((0, jsx_runtime_1.jsx)("li", __assign({ id: "mining-schema-field-n".concat(index), "data-testid": "mining-schema-field-n".concat(index), "data-ouia-component-id": field.name, "data-ouia-component-type": "edit-mining-field-row-", className: "editable-item ".concat(editing === index ? "editable-item--editing" : ""), ref: ref, tabIndex: 0, onKeyDown: function (event) {
                    if (event.key === "Escape") {
                        onCancel();
                    }
                } }, { children: (0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner" }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)("span", __assign({ className: "mining-schema-list__item__name" }, { children: field.name })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(MiningSchemaFieldLabels_1.default, { modelIndex: modelIndex, index: index, field: field, onEdit: addProperties, onDelete: deleteProperty, editing: index === editing }) }))] })) })) }), field.name)), index !== editing && ((0, jsx_runtime_1.jsx)("li", __assign({ id: "mining-schema-field-n".concat(index), "data-testid": "mining-schema-field-n".concat(index), "data-ouia-component-id": field.name, "data-ouia-component-type": "mining-field-row", className: "editable-item ".concat(editing === index ? "editable-item--editing" : ""), onClick: function (event) { return handleEdit(event); }, ref: ref, tabIndex: 0, onKeyDown: function (event) {
                    if (event.key === "Enter") {
                        handleEdit(event);
                    }
                    if (event.key === "Escape") {
                        onCancel();
                    }
                } }, { children: (0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner" }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, __assign({ "data-ouia-component-id": "validation-issue" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicator, { validations: validations }) })) })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)("span", __assign({ className: "mining-schema-list__item__name" }, { children: field.name })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(MiningSchemaFieldLabels_1.default, { modelIndex: modelIndex, index: index, field: field, onEdit: addProperties, onDelete: deleteProperty, editing: index === editing }) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "mining-schema-field-n".concat(index, "__delete"), "data-testid": "mining-schema-field-n".concat(index, "__delete"), ouiaId: "delete-field", className: "editable-item__delete", variant: "plain", onClick: function (e) { return handleDelete(e, "mouse"); }, onKeyDown: function (event) {
                                        if (event.key === "Enter") {
                                            handleDelete(event, "keyboard");
                                        }
                                    } }, { children: (0, jsx_runtime_1.jsx)(trash_icon_1.TrashIcon, {}) })) })] })) })) }), field.name))] }));
};
//# sourceMappingURL=MiningSchemaFields.js.map