"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputLabelsEditMode = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var arrow_alt_circle_right_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon");
var OutputFieldLabel_1 = require("./OutputFieldLabel");
var atoms_1 = require("../../EditorCore/atoms");
var PADDING = { marginRight: "4px" };
var OutputLabelsEditMode = function (props) {
    var optype = props.optype, setOptype = props.setOptype, targetField = props.targetField, setTargetField = props.setTargetField, targetFieldValidation = props.targetFieldValidation, feature = props.feature, setFeature = props.setFeature, value = props.value, setValue = props.setValue, rank = props.rank, setRank = props.setRank, rankOrder = props.rankOrder, setRankOrder = props.setRankOrder, segmentId = props.segmentId, setSegmentId = props.setSegmentId, isFinalResult = props.isFinalResult, setIsFinalResult = props.setIsFinalResult, commit = props.commit, viewExtendedProperties = props.viewExtendedProperties, isDisabled = props.isDisabled;
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [optype &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("OpType", optype, function () {
                    setOptype(undefined);
                    commit({
                        optype: undefined,
                    });
                }), targetFieldValidation.length > 0 ? ((0, jsx_runtime_1.jsxs)(atoms_1.ValidationIndicatorLabel, __assign({ validations: targetFieldValidation, cssClass: "output-fields-list__item__label" }, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "TargetField:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }))) : (targetField &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("TargetField", targetField, function () {
                    setTargetField(undefined);
                    commit({
                        targetField: undefined,
                    });
                })), feature &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("Feature", feature, function () {
                    setFeature(undefined);
                    commit({
                        feature: undefined,
                    });
                }), value &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("Value", value, function () {
                    setValue(undefined);
                    commit({
                        value: undefined,
                    });
                }), rank !== undefined &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("Rank", rank, function () {
                    setRank(undefined);
                    commit({
                        rank: undefined,
                    });
                }), rankOrder &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("RankOrder", rankOrder, function () {
                    setRankOrder(undefined);
                    commit({
                        rankOrder: undefined,
                    });
                }), segmentId &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("SegmentId", segmentId, function () {
                    setSegmentId(undefined);
                    commit({
                        segmentId: undefined,
                    });
                }), isFinalResult &&
                (0, OutputFieldLabel_1.OutputFieldLabel)("FinalResult", isFinalResult.toString(), function () {
                    setIsFinalResult(undefined);
                    commit({
                        isFinalResult: undefined,
                    });
                }), isDisabled && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ style: PADDING, variant: "outline", icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_right_icon_1.ArrowAltCircleRightIcon, {}) }, { children: "Edit properties" }))), !isDisabled && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ style: PADDING, variant: "outline", color: "cyan", href: "#outline", icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_right_icon_1.ArrowAltCircleRightIcon, {}), onClick: function (e) {
                    e.preventDefault();
                    viewExtendedProperties();
                } }, { children: "Edit properties" })))] }));
};
exports.OutputLabelsEditMode = OutputLabelsEditMode;
//# sourceMappingURL=OutputLabelsEditMode.js.map