"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsReducer = void 0;
var Actions_1 = require("./Actions");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var immer_1 = require("immer");
var paths_1 = require("../paths");
pmml_editor_marshaller_1.Characteristics[immer_1.immerable] = true;
var CharacteristicsReducer = function (historyService) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.Scorecard_AddCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forCharacteristics().build(), function (draft) {
                    draft.Characteristic.push({
                        name: action.payload.name,
                        reasonCode: action.payload.reasonCode,
                        baselineScore: action.payload.baselineScore,
                        Attribute: [],
                    });
                });
                break;
            case Actions_1.Actions.Scorecard_DeleteCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forCharacteristics().build(), function (draft) {
                    var characteristicIndex = action.payload.characteristicIndex;
                    if (characteristicIndex >= 0 && characteristicIndex < draft.Characteristic.length) {
                        draft.Characteristic.splice(characteristicIndex, 1);
                    }
                });
        }
        return state;
    };
};
exports.CharacteristicsReducer = CharacteristicsReducer;
//# sourceMappingURL=CharacteristicsReducer.js.map