"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldConstraintsBeCleared = exports.hasOnlyEmptyValues = exports.hasOnlyEmptyIntervals = exports.hasIntervals = exports.hasValidValues = exports.validateDataField = exports.validateDataFields = void 0;
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateDataFields = function (dataFields, validationRegistry) {
    dataFields.forEach(function (dataField, dataDictionaryIndex) {
        return (0, exports.validateDataField)(dataField, dataDictionaryIndex, validationRegistry);
    });
};
exports.validateDataFields = validateDataFields;
var validateDataField = function (dataField, dataDictionaryIndex, validationRegistry) {
    var _a, _b, _c;
    (_a = dataField.Interval) === null || _a === void 0 ? void 0 : _a.forEach(function (interval, index) {
        if (interval.leftMargin === undefined && interval.rightMargin === undefined) {
            validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forInterval(index).build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, Interval (").concat(index + 1, ") must have the start and/or end value set.")));
        }
    });
    (_b = dataField.Value) === null || _b === void 0 ? void 0 : _b.forEach(function (value, index) {
        if (value.value === "") {
            validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forValue(index).build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, Empty Constraint Value (").concat(index + 1, ")")));
        }
    });
    if (dataField.dataType === "string" && dataField.optype === "ordinal") {
        if (!(0, exports.hasValidValues)(dataField)) {
            validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, Values list required for ordinal strings")));
        }
    }
    if (dataField.isCyclic === "1") {
        if (dataField.optype === "ordinal" && !(0, exports.hasValidValues)(dataField)) {
            validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forValue().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, Values list is required for cyclic ordinal data types")));
        }
        if (dataField.optype === "continuous") {
            if (!(0, exports.hasValidValues)(dataField) && !(0, exports.hasIntervals)(dataField)) {
                validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, A Value or Interval constraint is required for cyclic continuous data types")));
            }
            if (dataField.Interval && ((_c = dataField.Interval) === null || _c === void 0 ? void 0 : _c.length) > 1) {
                validationRegistry.set((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(dataField.name, "\" data type, Continuous data types can have only a single interval constraint")));
            }
        }
    }
};
exports.validateDataField = validateDataField;
var hasValidValues = function (dataField) {
    return (dataField.Value &&
        dataField.Value.filter(function (value) { return value.property === "valid" || value.property === undefined; }).length > 0);
};
exports.hasValidValues = hasValidValues;
var hasIntervals = function (dataField) {
    return dataField.Interval && dataField.Interval.length > 0;
};
exports.hasIntervals = hasIntervals;
var hasOnlyEmptyIntervals = function (dataField) {
    var _a;
    return (_a = dataField.Interval) === null || _a === void 0 ? void 0 : _a.every(function (interval) { return interval.leftMargin === undefined && interval.rightMargin === undefined; });
};
exports.hasOnlyEmptyIntervals = hasOnlyEmptyIntervals;
var hasOnlyEmptyValues = function (dataField) {
    var _a;
    var validValues = (_a = dataField.Value) === null || _a === void 0 ? void 0 : _a.filter(function (value) { return value.property === undefined || value.property === "valid"; });
    return validValues === null || validValues === void 0 ? void 0 : validValues.every(function (value) { return value.value === ""; });
};
exports.hasOnlyEmptyValues = hasOnlyEmptyValues;
var shouldConstraintsBeCleared = function (updatedDataField, isCyclic, dataType, optype) {
    var result = false;
    if (isCyclic === "1" &&
        updatedDataField.isCyclic !== "1" &&
        !(updatedDataField.optype === "ordinal" && updatedDataField.dataType === "string") &&
        ((0, exports.hasOnlyEmptyIntervals)(updatedDataField) || (0, exports.hasOnlyEmptyValues)(updatedDataField))) {
        result = true;
    }
    if (isCyclic !== "1" &&
        updatedDataField.isCyclic !== "1" &&
        (updatedDataField.optype !== "ordinal" || updatedDataField.dataType !== "string") &&
        optype === "ordinal" &&
        dataType === "string" &&
        (0, exports.hasOnlyEmptyValues)(updatedDataField)) {
        result = true;
    }
    return result;
};
exports.shouldConstraintsBeCleared = shouldConstraintsBeCleared;
//# sourceMappingURL=DataDictionary.js.map