"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOutputsTargetFieldRequired = exports.validateOutput = exports.validateOutputs = void 0;
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateOutputs = function (modelIndex, outputFields, miningFields, validationRegistry) {
    if (outputFields.length === 0) {
        validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forOutput().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "At least one Output Field is required."));
    }
    outputFields === null || outputFields === void 0 ? void 0 : outputFields.forEach(function (outputField, dataDictionaryIndex) {
        return (0, exports.validateOutput)(modelIndex, outputField, dataDictionaryIndex, miningFields, validationRegistry);
    });
};
exports.validateOutputs = validateOutputs;
var validateOutput = function (modelIndex, outputField, outputFieldIndex, miningFields, validationRegistry) {
    if ((0, exports.isOutputsTargetFieldRequired)(miningFields) && outputField.targetField === undefined) {
        validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(outputField.name, "\": target field is required if Mining Schema has multiple target fields.")));
    }
};
exports.validateOutput = validateOutput;
var isOutputsTargetFieldRequired = function (miningFields) {
    return miningFields.filter(function (field) { return field.usageType === "target"; }).length > 1;
};
exports.isOutputsTargetFieldRequired = isOutputsTargetFieldRequired;
//# sourceMappingURL=Outputs.js.map