"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.anomalyDetectionModelFactory = exports.ANOMALY_DETECTION_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
exports.ANOMALY_DETECTION_MODEL = "\nelements.elements[(name = \"AnomalyDetectionModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $anomalyDetectionModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function anomalyDetectionModelFactory() {
    return new pmml4_4_1.AnomalyDetectionModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        functionName: "regression",
        algorithmType: "other",
    });
}
exports.anomalyDetectionModelFactory = anomalyDetectionModelFactory;
//# sourceMappingURL=AnomalyDetectionModel.js.map