export declare class PMMLObject {
    constructor(data: PMMLObject);
}
export declare class Expression extends PMMLObject {
    constructor(data: Expression);
}
export declare class Aggregate extends Expression {
    Extension?: Extension[];
    field: string;
    function: Function;
    groupField?: string;
    sqlWhere?: string;
    constructor(data: Aggregate);
}
export declare class Annotation extends PMMLObject {
    Extension?: any[];
    constructor(data: Annotation);
}
export declare class Anova extends PMMLObject {
    Extension?: Extension[];
    AnovaRow: AnovaRow[];
    target?: string;
    constructor(data: Anova);
}
export declare class AnovaRow extends PMMLObject {
    Extension?: Extension[];
    type: AnovaRowType;
    sumOfSquares: number;
    degreesOfFreedom: number;
    meanOfSquares?: number;
    fValue?: number;
    pValue?: number;
    constructor(data: AnovaRow);
}
export declare class Distribution extends PMMLObject {
    constructor(data: Distribution);
}
export declare class ContinuousDistribution extends Distribution {
    constructor(data: ContinuousDistribution);
}
export declare class AnyDistribution extends ContinuousDistribution {
    Extension?: Extension[];
    mean: number;
    variance: number;
    constructor(data: AnyDistribution);
}
export declare class Application extends PMMLObject {
    Extension?: Extension[];
    name: string;
    version?: string;
    constructor(data: Application);
}
export declare class Apply extends Expression {
    Extension?: Extension[];
    expressions?: Expression[];
    function: string;
    mapMissingTo?: string;
    defaultValue?: string;
    invalidValueTreatment?: InvalidValueTreatmentMethod;
    constructor(data: Apply);
}
export declare class Array extends PMMLObject {
    value?: any;
    n?: number;
    type: ArrayType;
    constructor(data: Array);
}
export declare class Measure extends PMMLObject {
    constructor(data: Measure);
}
export declare class Similarity extends Measure {
    constructor(data: Similarity);
}
export declare class BinarySimilarity extends Similarity {
    Extension?: Extension[];
    "c00-parameter": number;
    "c01-parameter": number;
    "c10-parameter": number;
    "c11-parameter": number;
    "d00-parameter": number;
    "d01-parameter": number;
    "d10-parameter": number;
    "d11-parameter": number;
    constructor(data: BinarySimilarity);
}
export declare class BlockIndicator extends PMMLObject {
    Extension?: Extension[];
    field: string;
    constructor(data: BlockIndicator);
}
export declare class BoundaryValueMeans extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: BoundaryValueMeans);
}
export declare class BoundaryValues extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: BoundaryValues);
}
export declare class Cell extends PMMLObject {
    value?: any;
    constructor(data: Cell);
}
export declare class Distance extends Measure {
    constructor(data: Distance);
}
export declare class Chebychev extends Distance {
    Extension?: Extension[];
    constructor(data: Chebychev);
}
export declare class ChildParent extends PMMLObject {
    Extension?: Extension[];
    FieldColumnPair?: FieldColumnPair[];
    TableLocator?: TableLocator;
    InlineTable?: InlineTable;
    childField: string;
    parentField: string;
    parentLevelField?: string;
    isRecursive?: Recursive;
    constructor(data: ChildParent);
}
export declare class CityBlock extends Distance {
    Extension?: Extension[];
    constructor(data: CityBlock);
}
export declare class ClassLabels extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: ClassLabels);
}
export declare class ClusteringModelQuality extends PMMLObject {
    Extension?: Extension[];
    dataName?: string;
    SSE?: number;
    SSB?: number;
    constructor(data: ClusteringModelQuality);
}
export declare class ComparisonField<E> extends PMMLObject {
    constructor(data: ComparisonField<E>);
}
export declare class ComparisonMeasure extends PMMLObject {
    Extension?: Extension[];
    measure?: Measure;
    kind: ComparisonMeasureKind;
    compareFunction?: CompareFunction;
    minimum?: number;
    maximum?: number;
    constructor(data: ComparisonMeasure);
}
export declare class ComplexArray extends Array {
    constructor(data: ComplexArray);
}
export interface ComplexValue {
}
export declare class Predicate extends PMMLObject {
    constructor(data: Predicate);
}
export declare class CompoundPredicate extends Predicate {
    Extension?: Extension[];
    predicates?: Predicate[];
    booleanOperator: CompoundPredicateBooleanOperator;
    constructor(data: CompoundPredicate);
}
export declare class ConfusionMatrix extends PMMLObject {
    Extension?: Extension[];
    ClassLabels: ClassLabels;
    Matrix: Matrix;
    constructor(data: ConfusionMatrix);
}
export declare class Constant extends Expression {
    value?: any;
    dataType?: DataType;
    missing?: boolean;
    constructor(data: Constant);
}
export declare class ContStats extends PMMLObject {
    Extension?: Extension[];
    Interval?: Interval[];
    Array?: Array[];
    totalValuesSum?: number;
    totalSquaresSum?: number;
    constructor(data: ContStats);
}
export declare class CorrelationFields extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: CorrelationFields);
}
export declare class CorrelationMethods extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: CorrelationMethods);
}
export declare class CorrelationValues extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: CorrelationValues);
}
export declare class Correlations extends PMMLObject {
    Extension?: Extension[];
    CorrelationFields: CorrelationFields;
    CorrelationValues: CorrelationValues;
    CorrelationMethods?: CorrelationMethods;
    constructor(data: Correlations);
}
export declare class Counts extends PMMLObject {
    Extension?: Extension[];
    totalFreq: number;
    missingFreq?: number;
    invalidFreq?: number;
    cardinality?: number;
    constructor(data: Counts);
}
export declare class DataDictionary extends PMMLObject {
    Extension?: Extension[];
    DataField: DataField[];
    Taxonomy?: Taxonomy[];
    numberOfFields?: number;
    constructor(data: DataDictionary);
}
export declare class Field<E> extends PMMLObject {
    constructor(data: Field<E>);
}
export declare class DataField extends Field<DataField> {
    Extension?: Extension[];
    Interval?: Interval[];
    Value?: Value[];
    name: string;
    displayName?: string;
    optype: OpType;
    dataType: DataType;
    taxonomy?: string;
    isCyclic?: Cyclic;
    constructor(data: DataField);
}
export declare class Decision extends PMMLObject {
    Extension?: Extension[];
    value: string;
    displayValue?: string;
    description?: string;
    constructor(data: Decision);
}
export declare class Decisions extends PMMLObject {
    Extension?: Extension[];
    Decision: Decision[];
    businessProblem?: string;
    description?: string;
    constructor(data: Decisions);
}
export declare class DefineFunction extends PMMLObject {
    Extension?: Extension[];
    ParameterField: ParameterField[];
    expression?: Expression;
    name: string;
    optype: OpType;
    dataType?: DataType;
    constructor(data: DefineFunction);
}
export declare class DerivedField extends Field<DerivedField> {
    Extension?: Extension[];
    expression?: Expression;
    Interval?: Interval[];
    Value?: Value[];
    name?: string;
    displayName?: string;
    optype: OpType;
    dataType: DataType;
    constructor(data: DerivedField);
}
export declare class DiscrStats extends PMMLObject {
    Extension?: Extension[];
    Array?: Array[];
    modalValue?: string;
    constructor(data: DiscrStats);
}
export declare class DiscreteDistribution extends Distribution {
    constructor(data: DiscreteDistribution);
}
export declare class Discretize extends Expression {
    Extension?: Extension[];
    DiscretizeBin?: DiscretizeBin[];
    field: string;
    mapMissingTo?: any;
    defaultValue?: any;
    dataType?: DataType;
    constructor(data: Discretize);
}
export declare class DiscretizeBin extends PMMLObject {
    Extension?: Extension[];
    Interval: Interval;
    binValue: any;
    constructor(data: DiscretizeBin);
}
export declare class EmbeddedModel extends PMMLObject {
    constructor(data: EmbeddedModel);
}
export declare class Entity<V> extends PMMLObject {
    constructor(data: Entity<V>);
}
export declare class Euclidean extends Distance {
    Extension?: Extension[];
    constructor(data: Euclidean);
}
export declare class Extension extends PMMLObject {
    content?: any[];
    extender?: string;
    name?: string;
    value?: string;
    constructor(data: Extension);
}
export declare class False extends Predicate {
    Extension?: Extension[];
    constructor(data: False);
}
export declare class FieldColumnPair extends PMMLObject {
    Extension?: Extension[];
    field: string;
    column: string;
    constructor(data: FieldColumnPair);
}
export declare class FieldRef extends Expression {
    Extension?: Extension[];
    field: string;
    mapMissingTo?: string;
    constructor(data: FieldRef);
}
export declare class GaussianDistribution extends ContinuousDistribution {
    Extension?: Extension[];
    mean: number;
    variance: number;
    constructor(data: GaussianDistribution);
}
export declare class Header extends PMMLObject {
    Extension?: Extension[];
    Application?: Application;
    Annotation?: Annotation[];
    Timestamp?: Timestamp;
    copyright?: string;
    description?: string;
    modelVersion?: string;
    constructor(data: Header);
}
export declare class InlineTable extends PMMLObject {
    Extension?: Extension[];
    row?: Row[];
    constructor(data: InlineTable);
}
export declare class SparseArray<E> extends PMMLObject {
    constructor(data: SparseArray<E>);
}
export declare class IntSparseArray extends SparseArray<number> {
    Indices?: number[];
    "INT-Entries"?: number[];
    n?: number;
    defaultValue?: number;
    constructor(data: IntSparseArray);
}
export declare class Interval extends PMMLObject {
    Extension?: Extension[];
    closure: Closure;
    leftMargin?: number;
    rightMargin?: number;
    constructor(data: Interval);
}
export declare class Jaccard extends Similarity {
    Extension?: Extension[];
    constructor(data: Jaccard);
}
export declare class Lag extends Expression {
    Extension?: Extension[];
    BlockIndicator?: BlockIndicator[];
    field: string;
    n?: number;
    aggregate?: string;
    constructor(data: Lag);
}
export declare class LiftData extends PMMLObject {
    Extension?: Extension[];
    ModelLiftGraph: ModelLiftGraph;
    OptimumLiftGraph?: OptimumLiftGraph;
    RandomLiftGraph?: RandomLiftGraph;
    targetFieldValue?: string;
    targetFieldDisplayValue?: string;
    rankingQuality?: number;
    constructor(data: LiftData);
}
export declare class LiftGraph extends PMMLObject {
    Extension?: Extension[];
    XCoordinates: XCoordinates;
    YCoordinates: YCoordinates;
    BoundaryValues?: BoundaryValues;
    BoundaryValueMeans?: BoundaryValueMeans;
    constructor(data: LiftGraph);
}
export declare class LinearNorm extends PMMLObject {
    Extension?: Extension[];
    orig: number;
    norm: number;
    constructor(data: LinearNorm);
}
export declare class LocalTransformations extends PMMLObject {
    Extension?: Extension[];
    DerivedField?: DerivedField[];
    constructor(data: LocalTransformations);
}
export declare class MapValues extends Expression {
    Extension?: Extension[];
    FieldColumnPair?: FieldColumnPair[];
    TableLocator?: TableLocator;
    InlineTable?: InlineTable;
    mapMissingTo?: any;
    defaultValue?: any;
    outputColumn: string;
    dataType?: DataType;
    constructor(data: MapValues);
}
export declare class MatCell extends PMMLObject {
    value?: any;
    row: number;
    col: number;
    constructor(data: MatCell);
}
export declare class Matrix extends PMMLObject {
    Array?: Array[];
    MatCell?: MatCell[];
    kind?: MatrixKind;
    nbRows?: number;
    nbCols?: number;
    diagDefault?: number;
    offDiagDefault?: number;
    constructor(data: Matrix);
}
export declare class MiningBuildTask extends PMMLObject {
    Extension?: Extension[];
    constructor(data: MiningBuildTask);
}
export declare class MiningField extends PMMLObject {
    Extension?: Extension[];
    name: string;
    usageType?: UsageType;
    optype?: OpType;
    importance?: number;
    outliers?: OutlierTreatmentMethod;
    lowValue?: number;
    highValue?: number;
    missingValueReplacement?: any;
    missingValueTreatment?: MissingValueTreatmentMethod;
    invalidValueTreatment?: InvalidValueTreatmentMethod;
    invalidValueReplacement?: any;
    constructor(data: MiningField);
}
export declare class MiningSchema extends PMMLObject {
    Extension?: Extension[];
    MiningField: MiningField[];
    constructor(data: MiningSchema);
}
export declare class Minkowski extends Distance {
    Extension?: Extension[];
    "p-parameter": number;
    constructor(data: Minkowski);
}
export declare class Model extends PMMLObject {
    constructor(data: Model);
}
export declare class ModelExplanation extends PMMLObject {
    Extension?: Extension[];
    PredictiveModelQuality?: PredictiveModelQuality[];
    ClusteringModelQuality?: ClusteringModelQuality[];
    Correlations?: Correlations;
    constructor(data: ModelExplanation);
}
export declare class ModelLiftGraph extends PMMLObject {
    Extension?: Extension[];
    LiftGraph: LiftGraph;
    constructor(data: ModelLiftGraph);
}
export declare class ModelStats extends PMMLObject {
    Extension?: Extension[];
    UnivariateStats?: UnivariateStats[];
    MultivariateStats?: MultivariateStats[];
    constructor(data: ModelStats);
}
export declare class ModelVerification extends PMMLObject {
    Extension?: Extension[];
    VerificationFields: VerificationFields;
    InlineTable: InlineTable;
    recordCount?: number;
    fieldCount?: number;
    constructor(data: ModelVerification);
}
export declare class MultivariateStat extends PMMLObject {
    Extension?: Extension[];
    name?: string;
    category?: any;
    exponent?: number;
    isIntercept?: boolean;
    importance?: number;
    stdError?: number;
    tValue?: number;
    chiSquareValue?: number;
    fStatistic?: number;
    dF?: number;
    pValueAlpha?: number;
    pValueInitial?: number;
    pValueFinal?: number;
    confidenceLevel?: number;
    confidenceLowerBound?: number;
    confidenceUpperBound?: number;
    constructor(data: MultivariateStat);
}
export declare class MultivariateStats extends PMMLObject {
    Extension?: Extension[];
    MultivariateStat: MultivariateStat[];
    targetCategory?: any;
    constructor(data: MultivariateStats);
}
export declare class NormContinuous extends Expression {
    Extension?: Extension[];
    LinearNorm: LinearNorm[];
    mapMissingTo?: number;
    field: string;
    outliers?: OutlierTreatmentMethod;
    constructor(data: NormContinuous);
}
export declare class NormDiscrete extends Expression {
    Extension?: Extension[];
    field: string;
    method?: Method;
    value: any;
    mapMissingTo?: number;
    constructor(data: NormDiscrete);
}
export declare class NumericInfo extends PMMLObject {
    Extension?: Extension[];
    Quantile?: Quantile[];
    minimum?: number;
    maximum?: number;
    mean?: number;
    standardDeviation?: number;
    median?: number;
    interQuartileRange?: number;
    constructor(data: NumericInfo);
}
export declare class OptimumLiftGraph extends PMMLObject {
    Extension?: Extension[];
    LiftGraph: LiftGraph;
    constructor(data: OptimumLiftGraph);
}
export declare class Output extends PMMLObject {
    Extension?: Extension[];
    OutputField: OutputField[];
    constructor(data: Output);
}
export declare class OutputField extends Field<OutputField> {
    Extension?: Extension[];
    Decisions?: Decisions;
    expression?: Expression;
    Value?: Value[];
    name: string;
    displayName?: string;
    optype?: OpType;
    dataType: DataType;
    targetField?: string;
    "x-reportField"?: string;
    feature?: ResultFeature;
    value?: any;
    ruleFeature?: RuleFeature;
    algorithm?: OutputFieldAlgorithm;
    rank?: number;
    rankBasis?: RankBasis;
    rankOrder?: RankOrder;
    isMultiValued?: string;
    segmentId?: string;
    isFinalResult?: boolean;
    constructor(data: OutputField);
}
export declare class PMML extends PMMLObject {
    Header: Header;
    MiningBuildTask?: MiningBuildTask;
    DataDictionary: DataDictionary;
    TransformationDictionary?: TransformationDictionary;
    models?: Model[];
    Extension?: Extension[];
    version: string;
    "x-baseVersion"?: string;
    constructor(data: PMML);
}
export interface PMMLFunctions {
}
export declare class ParameterField extends Field<ParameterField> {
    name: string;
    optype?: OpType;
    dataType?: DataType;
    displayName?: string;
    constructor(data: ParameterField);
}
export declare class Partition extends PMMLObject {
    Extension?: Extension[];
    PartitionFieldStats?: PartitionFieldStats[];
    name: string;
    size?: number;
    constructor(data: Partition);
}
export declare class PartitionFieldStats extends PMMLObject {
    Extension?: Extension[];
    Counts?: Counts;
    NumericInfo?: NumericInfo;
    Array?: Array[];
    field: string;
    weighted?: PartitionFieldStatsWeighted;
    constructor(data: PartitionFieldStats);
}
export declare class PoissonDistribution extends ContinuousDistribution {
    Extension?: Extension[];
    mean: number;
    constructor(data: PoissonDistribution);
}
export declare class PredictiveModelQuality extends PMMLObject {
    Extension?: Extension[];
    ConfusionMatrix?: ConfusionMatrix;
    LiftData?: LiftData[];
    ROC?: ROC;
    targetField: string;
    dataName?: string;
    dataUsage?: DataUsage;
    meanError?: number;
    meanAbsoluteError?: number;
    meanSquaredError?: number;
    rootMeanSquaredError?: number;
    "r-squared"?: number;
    "adj-r-squared"?: number;
    sumSquaredError?: number;
    sumSquaredRegression?: number;
    numOfRecords?: number;
    numOfRecordsWeighted?: number;
    numOfPredictors?: number;
    degreesOfFreedom?: number;
    fStatistic?: number;
    AIC?: number;
    BIC?: number;
    AICc?: number;
    constructor(data: PredictiveModelQuality);
}
export declare class Quantile extends PMMLObject {
    Extension?: Extension[];
    quantileLimit: number;
    quantileValue: number;
    constructor(data: Quantile);
}
export declare class ROC extends PMMLObject {
    Extension?: Extension[];
    ROCGraph: ROCGraph;
    positiveTargetFieldValue: string;
    positiveTargetFieldDisplayValue?: string;
    negativeTargetFieldValue?: string;
    negativeTargetFieldDisplayValue?: string;
    constructor(data: ROC);
}
export declare class ROCGraph extends PMMLObject {
    Extension?: Extension[];
    XCoordinates: XCoordinates;
    YCoordinates: YCoordinates;
    BoundaryValues?: BoundaryValues;
    constructor(data: ROCGraph);
}
export declare class RandomLiftGraph extends PMMLObject {
    Extension?: Extension[];
    LiftGraph: LiftGraph;
    constructor(data: RandomLiftGraph);
}
export declare class RealSparseArray extends SparseArray<number> {
    Indices?: number[];
    "REAL-Entries"?: number[];
    n?: number;
    defaultValue?: number;
    constructor(data: RealSparseArray);
}
export declare class ResultField extends Field<ResultField> {
    Extension?: Extension[];
    name: string;
    displayName?: string;
    optype?: OpType;
    dataType?: DataType;
    feature?: ResultFeature;
    value?: any;
    constructor(data: ResultField);
}
export declare class Row extends PMMLObject {
    content?: any[];
    constructor(data: Row);
}
export declare class ScoreDistribution extends PMMLObject {
    Extension?: Extension[];
    value: any;
    recordCount: number;
    confidence?: number;
    probability?: number;
    constructor(data: ScoreDistribution);
}
export declare class SimpleMatching extends Similarity {
    Extension?: Extension[];
    constructor(data: SimpleMatching);
}
export declare class SimplePredicate extends Predicate {
    Extension?: Extension[];
    field: string;
    operator: SimplePredicateOperator;
    value?: any;
    constructor(data: SimplePredicate);
}
export declare class SimpleSetPredicate extends Predicate {
    Extension?: Extension[];
    Array: Array;
    field: string;
    booleanOperator: SimpleSetPredicate$BooleanOperator;
    constructor(data: SimpleSetPredicate);
}
export declare class SquaredEuclidean extends Distance {
    Extension?: Extension[];
    constructor(data: SquaredEuclidean);
}
export interface StringValue<E> {
}
export declare class TableLocator extends PMMLObject {
    Extension?: Extension[];
    constructor(data: TableLocator);
}
export declare class Tanimoto extends Similarity {
    Extension?: Extension[];
    constructor(data: Tanimoto);
}
export declare class Target extends PMMLObject {
    Extension?: Extension[];
    TargetValue?: TargetValue[];
    field?: string;
    optype?: OpType;
    castInteger?: CastInteger;
    min?: number;
    max?: number;
    rescaleConstant?: number;
    rescaleFactor?: number;
    constructor(data: Target);
}
export declare class TargetValue extends PMMLObject {
    Extension?: Extension[];
    Partition?: Partition;
    value?: any;
    displayValue?: string;
    priorProbability?: number;
    defaultValue?: number;
    constructor(data: TargetValue);
}
export declare class Targets extends PMMLObject {
    Extension?: Extension[];
    Target: Target[];
    constructor(data: Targets);
}
export declare class Taxonomy extends PMMLObject {
    Extension?: Extension[];
    ChildParent: ChildParent[];
    name: string;
    constructor(data: Taxonomy);
}
export declare class TextIndex extends Expression {
    Extension?: Extension[];
    TextIndexNormalization?: TextIndexNormalization[];
    expression?: Expression;
    textField: string;
    localTermWeights?: TextIndexLocalTermWeights;
    isCaseSensitive?: boolean;
    maxLevenshteinDistance?: number;
    countHits?: CountHits;
    wordSeparatorCharacterRE?: string;
    tokenize?: boolean;
    constructor(data: TextIndex);
}
export declare class TextIndexNormalization extends PMMLObject {
    Extension?: Extension[];
    TableLocator?: TableLocator;
    InlineTable?: InlineTable;
    inField?: string;
    outField?: string;
    regexField?: string;
    recursive?: boolean;
    isCaseSensitive?: boolean;
    maxLevenshteinDistance?: number;
    wordSeparatorCharacterRE?: string;
    tokenize?: boolean;
    constructor(data: TextIndexNormalization);
}
export declare class Timestamp extends PMMLObject {
    Extension?: any[];
    constructor(data: Timestamp);
}
export declare class TransformationDictionary extends PMMLObject {
    Extension?: Extension[];
    DefineFunction?: DefineFunction[];
    DerivedField?: DerivedField[];
    constructor(data: TransformationDictionary);
}
export declare class True extends Predicate {
    Extension?: Extension[];
    constructor(data: True);
}
export declare class UniformDistribution extends ContinuousDistribution {
    Extension?: Extension[];
    lower: number;
    upper: number;
    constructor(data: UniformDistribution);
}
export declare class UnivariateStats extends PMMLObject {
    Extension?: Extension[];
    Counts?: Counts;
    NumericInfo?: NumericInfo;
    DiscrStats?: DiscrStats;
    ContStats?: ContStats;
    Anova?: Anova;
    field?: string;
    weighted?: UnivariateStatsWeighted;
    constructor(data: UnivariateStats);
}
export declare class Value extends PMMLObject {
    Extension?: Extension[];
    value: any;
    displayValue?: string;
    property?: Property;
    constructor(data: Value);
}
export declare class VerificationField extends PMMLObject {
    Extension?: Extension[];
    field: string;
    column?: string;
    precision?: number;
    zeroThreshold?: number;
    constructor(data: VerificationField);
}
export declare class VerificationFields extends PMMLObject {
    Extension?: Extension[];
    VerificationField: VerificationField[];
    constructor(data: VerificationFields);
}
export declare class XCoordinates extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: XCoordinates);
}
export declare class YCoordinates extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: YCoordinates);
}
export declare class AnomalyDetectionModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    LocalTransformations?: LocalTransformations;
    ModelVerification?: ModelVerification;
    model?: Model;
    MeanClusterDistances?: MeanClusterDistances;
    modelName?: string;
    algorithmName?: string;
    functionName: MiningFunction;
    algorithmType: string;
    sampleDataSize?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: AnomalyDetectionModel);
}
export declare class MeanClusterDistances extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: MeanClusterDistances);
}
export declare class AssociationModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    LocalTransformations?: LocalTransformations;
    Item?: Item[];
    Itemset?: Itemset[];
    AssociationRule?: AssociationRule[];
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    numberOfTransactions: number;
    maxNumberOfItemsPerTA?: number;
    avgNumberOfItemsPerTA?: number;
    minimumSupport: number;
    minimumConfidence: number;
    lengthLimit?: number;
    numberOfItems: number;
    numberOfItemsets: number;
    numberOfRules: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: AssociationModel);
}
export declare class AssociationRule extends Entity<string> {
    Extension?: Extension[];
    antecedent: string;
    consequent: string;
    support: number;
    confidence: number;
    lift?: number;
    leverage?: number;
    affinity?: number;
    id?: string;
    constructor(data: AssociationRule);
}
export declare class Item extends PMMLObject {
    Extension?: Extension[];
    id: string;
    value: string;
    field?: string;
    category?: string;
    mappedValue?: string;
    weight?: number;
    constructor(data: Item);
}
export declare class ItemRef extends PMMLObject {
    Extension?: Extension[];
    itemRef: string;
    constructor(data: ItemRef);
}
export declare class Itemset extends PMMLObject {
    Extension?: Extension[];
    ItemRef?: ItemRef[];
    id: string;
    support?: number;
    numberOfItems?: number;
    constructor(data: Itemset);
}
export declare class Alternate extends PMMLObject {
    continuousDistribution?: ContinuousDistribution;
    constructor(data: Alternate);
}
export declare class Baseline extends PMMLObject {
    continuousDistribution?: ContinuousDistribution;
    CountTable?: CountTable;
    NormalizedCountTable?: CountTable;
    FieldRef?: FieldRef[];
    constructor(data: Baseline);
}
export declare class BaselineModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    TestDistributions: TestDistributions;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: BaselineModel);
}
export declare class CountTable extends DiscreteDistribution {
    Extension?: Extension[];
    FieldValue?: FieldValue[];
    FieldValueCount?: FieldValueCount[];
    sample?: number;
    constructor(data: CountTable);
}
export declare class FieldValue extends PMMLObject {
    Extension?: Extension[];
    FieldValue?: FieldValue[];
    FieldValueCount?: FieldValueCount[];
    field: string;
    value: any;
    constructor(data: FieldValue);
}
export declare class FieldValueCount extends PMMLObject {
    Extension?: Extension[];
    field: string;
    value: any;
    count: number;
    constructor(data: FieldValueCount);
}
export declare class TestDistributions extends PMMLObject {
    Extension?: Extension[];
    Baseline: Baseline;
    Alternate?: Alternate;
    field: string;
    testStatistic: TestStatistic;
    resetValue?: number;
    windowSize?: number;
    weightField?: string;
    normalizationScheme?: string;
    constructor(data: TestDistributions);
}
export declare class BayesianNetworkModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    BayesianNetworkNodes: BayesianNetworkNodes;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    modelType?: string;
    inferenceMethod?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: BayesianNetworkModel);
}
export declare class BayesianNetworkNodes extends PMMLObject {
    Extension?: Extension[];
    content?: PMMLObject[];
    constructor(data: BayesianNetworkNodes);
}
export declare class ContinuousConditionalProbability extends PMMLObject {
    Extension?: Extension[];
    ParentValue?: ParentValue[];
    ContinuousDistribution: BayesianContinuousDistribution[];
    count?: number;
    constructor(data: ContinuousConditionalProbability);
}
export declare class BayesianContinuousDistribution extends PMMLObject {
    Extension?: Extension[];
    TriangularDistributionForBN?: TriangularDistribution;
    NormalDistributionForBN?: NormalDistribution;
    LognormalDistributionForBN?: LognormalDistribution;
    UniformDistributionForBN?: BayesianUniformDistribution;
    constructor(data: BayesianContinuousDistribution);
}
export declare class ContinuousNode extends PMMLObject {
    Extension?: Extension[];
    DerivedField?: DerivedField[];
    content?: PMMLObject[];
    name: string;
    count?: number;
    constructor(data: ContinuousNode);
}
export declare class DiscreteConditionalProbability extends PMMLObject {
    Extension?: Extension[];
    ParentValue: ParentValue[];
    ValueProbability: ValueProbability[];
    count?: number;
    constructor(data: DiscreteConditionalProbability);
}
export declare class DiscreteNode extends PMMLObject {
    Extension?: Extension[];
    DerivedField?: DerivedField[];
    content?: PMMLObject[];
    name: string;
    count?: number;
    constructor(data: DiscreteNode);
}
export declare class LognormalDistribution extends PMMLObject {
    Extension?: Extension[];
    Mean: Mean;
    Variance: Variance;
    constructor(data: LognormalDistribution);
}
export declare class Lower extends PMMLObject {
    Extension?: Extension[];
    expression?: Expression;
    constructor(data: Lower);
}
export declare class Mean extends PMMLObject {
    Extension?: Extension[];
    expression?: Expression;
    constructor(data: Mean);
}
export declare class NormalDistribution extends PMMLObject {
    Extension?: Extension[];
    Mean: Mean;
    Variance: Variance;
    constructor(data: NormalDistribution);
}
export declare class ParentValue extends PMMLObject {
    Extension?: Extension[];
    parent: string;
    value: any;
    constructor(data: ParentValue);
}
export declare class TriangularDistribution extends PMMLObject {
    Extension?: Extension[];
    Mean: Mean;
    Lower: Lower;
    Upper: Upper;
    constructor(data: TriangularDistribution);
}
export declare class BayesianUniformDistribution extends PMMLObject {
    Extension?: Extension[];
    Lower: Lower;
    Upper: Upper;
    constructor(data: BayesianUniformDistribution);
}
export declare class Upper extends PMMLObject {
    Extension?: Extension[];
    expression?: Expression;
    constructor(data: Upper);
}
export declare class ValueProbability extends PMMLObject {
    Extension?: Extension[];
    value: any;
    probability: number;
    constructor(data: ValueProbability);
}
export declare class Variance extends PMMLObject {
    Extension?: Extension[];
    expression?: Expression;
    constructor(data: Variance);
}
export declare class CenterFields extends PMMLObject {
    DerivedField: DerivedField[];
    constructor(data: CenterFields);
}
export declare class Cluster extends Entity<string> {
    Extension?: Extension[];
    KohonenMap?: KohonenMap;
    Array?: Array;
    Partition?: Partition;
    Covariances?: Covariances;
    id?: string;
    name?: string;
    size?: number;
    constructor(data: Cluster);
}
export declare class ClusteringField extends ComparisonField<ClusteringField> {
    Extension?: Extension[];
    Comparisons?: Comparisons;
    field: string;
    isCenterField?: CenterField;
    fieldWeight?: number;
    similarityScale?: number;
    compareFunction?: CompareFunction;
    constructor(data: ClusteringField);
}
export declare class ClusteringModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    LocalTransformations?: LocalTransformations;
    ComparisonMeasure: ComparisonMeasure;
    ClusteringField: ClusteringField[];
    CenterFields?: CenterFields;
    MissingValueWeights?: MissingValueWeights;
    Cluster: Cluster[];
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    modelClass: ModelClass;
    numberOfClusters: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: ClusteringModel);
}
export declare class Comparisons extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: Comparisons);
}
export declare class Covariances extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: Covariances);
}
export declare class KohonenMap extends PMMLObject {
    Extension?: Extension[];
    coord1?: number;
    coord2?: number;
    coord3?: number;
    constructor(data: KohonenMap);
}
export declare class MissingValueWeights extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: MissingValueWeights);
}
export declare class ARDSquaredExponentialKernel extends PMMLObject {
    Extension?: Extension[];
    Lambda?: Lambda[];
    description?: string;
    gamma?: number;
    noiseVariance?: number;
    constructor(data: ARDSquaredExponentialKernel);
}
export declare class AbsoluteExponentialKernel extends PMMLObject {
    Extension?: Extension[];
    Lambda?: Lambda[];
    description?: string;
    gamma?: number;
    noiseVariance?: number;
    constructor(data: AbsoluteExponentialKernel);
}
export declare class GaussianProcessModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    RadialBasisKernel?: GaussianRadialBasisKernel;
    ARDSquaredExponentialKernel?: ARDSquaredExponentialKernel;
    AbsoluteExponentialKernel?: AbsoluteExponentialKernel;
    GeneralizedExponentialKernel?: GeneralizedExponentialKernel;
    TrainingInstances: TrainingInstances;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    optimizer?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: GaussianProcessModel);
}
export declare class GeneralizedExponentialKernel extends PMMLObject {
    Extension?: Extension[];
    Lambda?: Lambda[];
    description?: string;
    gamma?: number;
    noiseVariance?: number;
    degree?: number;
    constructor(data: GeneralizedExponentialKernel);
}
export declare class Lambda extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: Lambda);
}
export declare class GaussianRadialBasisKernel extends PMMLObject {
    Extension?: Extension[];
    description?: string;
    gamma?: number;
    noiseVariance?: number;
    lambda?: number;
    constructor(data: GaussianRadialBasisKernel);
}
export declare class BaseCumHazardTables extends PMMLObject {
    Extension?: Extension[];
    BaselineStratum?: BaselineStratum[];
    BaselineCell?: BaselineCell[];
    maxTime?: number;
    constructor(data: BaseCumHazardTables);
}
export declare class BaselineCell extends PMMLObject {
    Extension?: Extension[];
    time: number;
    cumHazard: number;
    constructor(data: BaselineCell);
}
export declare class BaselineStratum extends PMMLObject {
    Extension?: Extension[];
    BaselineCell?: BaselineCell[];
    value: any;
    label?: string;
    maxTime: number;
    constructor(data: BaselineStratum);
}
export declare class Categories extends PMMLObject {
    Extension?: Extension[];
    Category: Category[];
    constructor(data: Categories);
}
export declare class Category extends PMMLObject {
    Extension?: Extension[];
    value: any;
    constructor(data: Category);
}
export declare class PredictorList extends PMMLObject {
    constructor(data: PredictorList);
}
export declare class CovariateList extends PredictorList {
    Extension?: Extension[];
    Predictor?: Predictor[];
    constructor(data: CovariateList);
}
export declare class EventValues extends PMMLObject {
    Extension?: Extension[];
    Value?: Value[];
    Interval?: Interval[];
    constructor(data: EventValues);
}
export declare class FactorList extends PredictorList {
    Extension?: Extension[];
    Predictor?: Predictor[];
    constructor(data: FactorList);
}
export declare class GeneralRegressionModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    ParameterList: ParameterList;
    FactorList?: FactorList;
    CovariateList?: CovariateList;
    PPMatrix: PPMatrix;
    PCovMatrix?: PCovMatrix;
    ParamMatrix: ParamMatrix;
    EventValues?: EventValues;
    BaseCumHazardTables?: BaseCumHazardTables;
    ModelVerification?: ModelVerification;
    targetVariableName?: string;
    modelType: GeneralRegressionModelType;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    targetReferenceCategory?: any;
    cumulativeLink?: CumulativeLinkFunction;
    linkFunction?: LinkFunction;
    linkParameter?: number;
    trialsVariable?: string;
    trialsValue?: number;
    distribution?: GeneralRegressionModelDistribution;
    distParameter?: number;
    offsetVariable?: string;
    offsetValue?: number;
    modelDF?: number;
    endTimeVariable?: string;
    startTimeVariable?: string;
    subjectIDVariable?: string;
    statusVariable?: string;
    baselineStrataVariable?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: GeneralRegressionModel);
}
export declare class ParameterCell extends PMMLObject {
    constructor(data: ParameterCell);
}
export declare class PCell extends ParameterCell {
    Extension?: Extension[];
    targetCategory?: any;
    parameterName: string;
    beta: number;
    df?: number;
    constructor(data: PCell);
}
export declare class PCovCell extends PMMLObject {
    Extension?: Extension[];
    pRow: string;
    pCol: string;
    tRow?: string;
    tCol?: string;
    value: number;
    targetCategory?: any;
    constructor(data: PCovCell);
}
export declare class PCovMatrix extends PMMLObject {
    Extension?: Extension[];
    PCovCell: PCovCell[];
    type?: PCovMatrixType;
    constructor(data: PCovMatrix);
}
export declare class PPCell extends ParameterCell {
    Extension?: Extension[];
    value: any;
    predictorName: string;
    parameterName: string;
    targetCategory?: any;
    constructor(data: PPCell);
}
export declare class PPMatrix extends PMMLObject {
    Extension?: Extension[];
    PPCell?: PPCell[];
    constructor(data: PPMatrix);
}
export declare class ParamMatrix extends PMMLObject {
    Extension?: Extension[];
    PCell?: PCell[];
    constructor(data: ParamMatrix);
}
export declare class Parameter extends PMMLObject {
    Extension?: Extension[];
    name: string;
    label?: string;
    referencePoint?: number;
    constructor(data: Parameter);
}
export declare class ParameterList extends PMMLObject {
    Extension?: Extension[];
    Parameter?: Parameter[];
    constructor(data: ParameterList);
}
export declare class Predictor extends PMMLObject {
    Extension?: Extension[];
    Categories?: Categories;
    Matrix?: Matrix;
    name: string;
    contrastMatrixType?: string;
    constructor(data: Predictor);
}
export declare class MiningModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    embeddedModels?: EmbeddedModel[];
    Segmentation?: Segmentation;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: MiningModel);
}
export declare class Segment extends Entity<string> {
    Extension?: Extension[];
    predicate?: Predicate;
    model?: Model;
    VariableWeight?: VariableWeight;
    id?: string;
    weight?: number;
    constructor(data: Segment);
}
export declare class Segmentation extends PMMLObject {
    Extension?: Extension[];
    LocalTransformations?: LocalTransformations;
    Segment: Segment[];
    multipleModelMethod: MultipleModelMethod;
    missingPredictionTreatment?: MissingPredictionTreatment;
    missingThreshold?: number;
    constructor(data: Segmentation);
}
export declare class VariableWeight extends PMMLObject {
    Extension?: Extension[];
    field: string;
    constructor(data: VariableWeight);
}
export declare class BayesInput extends PMMLObject {
    Extension?: Extension[];
    TargetValueStats?: TargetValueStats;
    DerivedField?: DerivedField;
    PairCounts?: PairCounts[];
    fieldName: string;
    constructor(data: BayesInput);
}
export declare class BayesInputs extends PMMLObject {
    Extension?: Extension[];
    BayesInput: BayesInput[];
    constructor(data: BayesInputs);
}
export declare class BayesOutput extends PMMLObject {
    Extension?: Extension[];
    TargetValueCounts: TargetValueCounts;
    fieldName: string;
    constructor(data: BayesOutput);
}
export declare class NaiveBayesModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    BayesInputs: BayesInputs;
    BayesOutput: BayesOutput;
    ModelVerification?: ModelVerification;
    modelName?: string;
    threshold: number;
    functionName: MiningFunction;
    algorithmName?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: NaiveBayesModel);
}
export declare class PairCounts extends PMMLObject {
    Extension?: Extension[];
    TargetValueCounts: TargetValueCounts;
    value: any;
    constructor(data: PairCounts);
}
export declare class TargetValueCount extends PMMLObject {
    Extension?: Extension[];
    value: any;
    count: number;
    constructor(data: TargetValueCount);
}
export declare class TargetValueCounts extends PMMLObject {
    Extension?: Extension[];
    TargetValueCount: TargetValueCount[];
    constructor(data: TargetValueCounts);
}
export declare class TargetValueStat extends PMMLObject {
    Extension?: Extension[];
    continuousDistribution?: ContinuousDistribution;
    value: any;
    constructor(data: TargetValueStat);
}
export declare class TargetValueStats extends PMMLObject {
    Extension?: Extension[];
    TargetValueStat: TargetValueStat[];
    constructor(data: TargetValueStats);
}
export declare class InstanceField extends PMMLObject {
    Extension?: Extension[];
    field: string;
    column?: string;
    constructor(data: InstanceField);
}
export declare class InstanceFields extends PMMLObject {
    Extension?: Extension[];
    InstanceField: InstanceField[];
    constructor(data: InstanceFields);
}
export declare class KNNInput extends ComparisonField<KNNInput> {
    Extension?: Extension[];
    field: string;
    fieldWeight?: number;
    compareFunction?: CompareFunction;
    constructor(data: KNNInput);
}
export declare class KNNInputs extends PMMLObject {
    Extension?: Extension[];
    KNNInput: KNNInput[];
    constructor(data: KNNInputs);
}
export declare class NearestNeighborModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    TrainingInstances: TrainingInstances;
    ComparisonMeasure: ComparisonMeasure;
    KNNInputs: KNNInputs;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    numberOfNeighbors: number;
    continuousScoringMethod?: ContinuousScoringMethod;
    categoricalScoringMethod?: CategoricalScoringMethod;
    instanceIdVariable?: string;
    threshold?: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: NearestNeighborModel);
}
export declare class TrainingInstances extends PMMLObject {
    Extension?: Extension[];
    InstanceFields: InstanceFields;
    TableLocator?: TableLocator;
    InlineTable?: InlineTable;
    isTransformed?: boolean;
    recordCount?: number;
    fieldCount?: number;
    constructor(data: TrainingInstances);
}
export declare class Connection extends PMMLObject {
    Extension?: Extension[];
    from: string;
    weight: number;
    constructor(data: Connection);
}
export declare class NeuralEntity extends Entity<string> {
    constructor(data: NeuralEntity);
}
export declare class NeuralInput extends NeuralEntity {
    Extension?: Extension[];
    DerivedField: DerivedField;
    id: string;
    constructor(data: NeuralInput);
}
export declare class NeuralInputs extends PMMLObject {
    Extension?: Extension[];
    NeuralInput: NeuralInput[];
    numberOfInputs?: number;
    constructor(data: NeuralInputs);
}
export declare class NeuralLayer extends PMMLObject {
    Extension?: Extension[];
    Neuron: Neuron[];
    numberOfNeurons?: number;
    activationFunction?: ActivationFunction;
    threshold?: number;
    width?: number;
    altitude?: number;
    normalizationMethod?: NeuralNetworkNormalizationMethod;
    constructor(data: NeuralLayer);
}
export declare class NeuralNetwork extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    NeuralInputs: NeuralInputs;
    NeuralLayer: NeuralLayer[];
    NeuralOutputs?: NeuralOutputs;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    activationFunction: ActivationFunction;
    normalizationMethod?: NeuralNetworkNormalizationMethod;
    threshold?: number;
    width?: number;
    altitude?: number;
    numberOfLayers?: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: NeuralNetwork);
}
export declare class NeuralOutput extends PMMLObject {
    Extension?: Extension[];
    DerivedField: DerivedField;
    outputNeuron: string;
    constructor(data: NeuralOutput);
}
export declare class NeuralOutputs extends PMMLObject {
    Extension?: Extension[];
    NeuralOutput: NeuralOutput[];
    numberOfOutputs?: number;
    constructor(data: NeuralOutputs);
}
export declare class Neuron extends NeuralEntity {
    Extension?: Extension[];
    Con: Connection[];
    id: string;
    bias?: number;
    width?: number;
    altitude?: number;
    constructor(data: Neuron);
}
export declare class Term extends PMMLObject {
    constructor(data: Term);
}
export declare class CategoricalPredictor extends Term {
    Extension?: Extension[];
    name: string;
    value: any;
    coefficient: number;
    constructor(data: CategoricalPredictor);
}
export declare class NumericPredictor extends Term {
    Extension?: Extension[];
    name: string;
    exponent?: number;
    coefficient: number;
    constructor(data: NumericPredictor);
}
export declare class PredictorTerm extends Term {
    Extension?: Extension[];
    FieldRef: FieldRef[];
    name?: string;
    coefficient: number;
    constructor(data: PredictorTerm);
}
export declare class Regression extends EmbeddedModel {
    Extension?: Extension[];
    Output?: Output;
    ModelStats?: ModelStats;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    ResultField?: ResultField[];
    RegressionTable: RegressionTable[];
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    normalizationMethod?: RegressionNormalizationMethod;
    constructor(data: Regression);
}
export declare class RegressionModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    RegressionTable: RegressionTable[];
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    modelType?: RegressionModelType;
    targetFieldName?: string;
    normalizationMethod?: RegressionModelNormalizationMethod;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: RegressionModel);
}
export declare class RegressionTable extends PMMLObject {
    Extension?: Extension[];
    NumericPredictor?: NumericPredictor[];
    CategoricalPredictor?: CategoricalPredictor[];
    PredictorTerm?: PredictorTerm[];
    intercept: number;
    targetCategory?: any;
    constructor(data: RegressionTable);
}
export declare class Rule extends Entity<string> {
    constructor(data: Rule);
}
export declare class CompoundRule extends Rule {
    Extension?: Extension[];
    predicate?: Predicate;
    rules?: Rule[];
    constructor(data: CompoundRule);
}
export declare class RuleSelectionMethod extends PMMLObject {
    Extension?: Extension[];
    criterion: Criterion;
    constructor(data: RuleSelectionMethod);
}
export declare class RuleSet extends PMMLObject {
    Extension?: Extension[];
    RuleSelectionMethod: RuleSelectionMethod[];
    ScoreDistribution?: ScoreDistribution[];
    rules?: Rule[];
    recordCount?: number;
    nbCorrect?: number;
    defaultScore?: any;
    defaultConfidence?: number;
    constructor(data: RuleSet);
}
export declare class RuleSetModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    RuleSet: RuleSet;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: RuleSetModel);
}
export declare class SimpleRule extends Rule {
    Extension?: Extension[];
    predicate?: Predicate;
    ScoreDistribution?: ScoreDistribution[];
    id?: string;
    score: any;
    recordCount?: number;
    nbCorrect?: number;
    confidence?: number;
    weight?: number;
    constructor(data: SimpleRule);
}
export declare class Attribute extends PMMLObject {
    Extension?: Extension[];
    predicate?: Predicate;
    ComplexPartialScore?: ComplexPartialScore;
    reasonCode?: string;
    partialScore?: number;
    constructor(data: Attribute);
}
export declare class Characteristic extends PMMLObject {
    Extension?: Extension[];
    Attribute: Attribute[];
    name?: string;
    reasonCode?: string;
    baselineScore?: number;
    constructor(data: Characteristic);
}
export declare class Characteristics extends PMMLObject {
    Extension?: Extension[];
    Characteristic: Characteristic[];
    constructor(data: Characteristics);
}
export declare class ComplexPartialScore extends PMMLObject {
    Extension?: Extension[];
    expression?: Expression;
    constructor(data: ComplexPartialScore);
}
export declare class Scorecard extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    Characteristics: Characteristics;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    initialScore?: number;
    useReasonCodes?: boolean;
    reasonCodeAlgorithm?: ReasonCodeAlgorithm;
    baselineScore?: number;
    baselineMethod?: BaselineMethod;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: Scorecard);
}
export declare class AntecedentSequence extends PMMLObject {
    Extension?: Extension[];
    SequenceReference: SequenceReference;
    Time?: Time;
    constructor(data: AntecedentSequence);
}
export declare class ConsequentSequence extends PMMLObject {
    Extension?: Extension[];
    SequenceReference: SequenceReference;
    Time?: Time;
    constructor(data: ConsequentSequence);
}
export declare class Constraints extends PMMLObject {
    Extension?: Extension[];
    minimumNumberOfItems?: number;
    maximumNumberOfItems?: number;
    minimumNumberOfAntecedentItems?: number;
    maximumNumberOfAntecedentItems?: number;
    minimumNumberOfConsequentItems?: number;
    maximumNumberOfConsequentItems?: number;
    minimumSupport?: number;
    minimumConfidence?: number;
    minimumLift?: number;
    minimumTotalSequenceTime?: number;
    maximumTotalSequenceTime?: number;
    minimumItemsetSeparationTime?: number;
    maximumItemsetSeparationTime?: number;
    minimumAntConsSeparationTime?: number;
    maximumAntConsSeparationTime?: number;
    constructor(data: Constraints);
}
export declare class Delimiter extends PMMLObject {
    Extension?: Extension[];
    delimiter: TimeWindow;
    gap: Gap;
    constructor(data: Delimiter);
}
export declare class Sequence extends PMMLObject {
    Extension?: Extension[];
    SetReference: SetReference;
    content?: PMMLObject[];
    Time?: Time;
    id: string;
    numberOfSets?: number;
    occurrence?: number;
    support?: number;
    constructor(data: Sequence);
}
export declare class SequenceModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    ModelStats?: ModelStats;
    LocalTransformations?: LocalTransformations;
    Constraints?: Constraints;
    Item?: Item[];
    Itemset?: Itemset[];
    SetPredicate?: SetPredicate[];
    Sequence: Sequence[];
    SequenceRule?: SequenceRule[];
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    numberOfTransactions?: number;
    maxNumberOfItemsPerTransaction?: number;
    avgNumberOfItemsPerTransaction?: number;
    numberOfTransactionGroups?: number;
    maxNumberOfTAsPerTAGroup?: number;
    avgNumberOfTAsPerTAGroup?: number;
    minimumSupport: number;
    minimumConfidence: number;
    lengthLimit?: number;
    numberOfItems: number;
    numberOfSets: number;
    numberOfSequences: number;
    numberOfRules: number;
    timeWindowWidth?: number;
    minimumTime?: number;
    maximumTime?: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: SequenceModel);
}
export declare class SequenceReference extends PMMLObject {
    Extension?: Extension[];
    seqId: string;
    constructor(data: SequenceReference);
}
export declare class SequenceRule extends Entity<string> {
    content?: any[];
    id: string;
    numberOfSets: number;
    occurrence: number;
    support: number;
    confidence: number;
    lift?: number;
    constructor(data: SequenceRule);
}
export declare class SetPredicate extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    id: string;
    field: string;
    operator?: SetPredicateOperator;
    constructor(data: SetPredicate);
}
export declare class SetReference extends PMMLObject {
    Extension?: Extension[];
    setId: string;
    constructor(data: SetReference);
}
export declare class Time extends PMMLObject {
    Extension?: Extension[];
    min?: number;
    max?: number;
    mean?: number;
    standardDeviation?: number;
    constructor(data: Time);
}
export declare class Coefficient extends PMMLObject {
    Extension?: Extension[];
    value?: number;
    constructor(data: Coefficient);
}
export declare class Coefficients extends PMMLObject {
    Extension?: Extension[];
    Coefficient: Coefficient[];
    numberOfCoefficients?: number;
    absoluteValue?: number;
    constructor(data: Coefficients);
}
export declare class Kernel extends PMMLObject {
    constructor(data: Kernel);
}
export declare class LinearKernel extends Kernel {
    Extension?: Extension[];
    description?: string;
    constructor(data: LinearKernel);
}
export declare class PolynomialKernel extends Kernel {
    Extension?: Extension[];
    description?: string;
    gamma?: number;
    coef0?: number;
    degree?: number;
    constructor(data: PolynomialKernel);
}
export declare class VectorMachineRadialBasisKernel extends Kernel {
    Extension?: Extension[];
    description?: string;
    gamma?: number;
    constructor(data: VectorMachineRadialBasisKernel);
}
export declare class SigmoidKernel extends Kernel {
    Extension?: Extension[];
    description?: string;
    gamma?: number;
    coef0?: number;
    constructor(data: SigmoidKernel);
}
export declare class SupportVector extends PMMLObject {
    Extension?: Extension[];
    vectorId: string;
    constructor(data: SupportVector);
}
export declare class SupportVectorMachine extends PMMLObject {
    Extension?: Extension[];
    SupportVectors?: SupportVectors;
    Coefficients: Coefficients;
    targetCategory?: any;
    alternateTargetCategory?: any;
    threshold?: number;
    constructor(data: SupportVectorMachine);
}
export declare class SupportVectorMachineModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    kernel?: Kernel;
    VectorDictionary: VectorDictionary;
    SupportVectorMachine: SupportVectorMachine[];
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    threshold?: number;
    svmRepresentation?: Representation;
    alternateBinaryTargetCategory?: any;
    classificationMethod?: ClassificationMethod;
    maxWins?: boolean;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: SupportVectorMachineModel);
}
export declare class SupportVectors extends PMMLObject {
    Extension?: Extension[];
    SupportVector: SupportVector[];
    numberOfSupportVectors?: number;
    numberOfAttributes?: number;
    constructor(data: SupportVectors);
}
export declare class VectorDictionary extends PMMLObject {
    Extension?: Extension[];
    VectorFields: VectorFields;
    VectorInstance?: VectorInstance[];
    numberOfVectors?: number;
    constructor(data: VectorDictionary);
}
export declare class VectorFields extends PMMLObject {
    Extension?: Extension[];
    content?: PMMLObject[];
    numberOfFields?: number;
    constructor(data: VectorFields);
}
export declare class VectorInstance extends PMMLObject {
    Extension?: Extension[];
    "REAL-SparseArray"?: RealSparseArray;
    Array?: Array;
    id: string;
    constructor(data: VectorInstance);
}
export declare class DocumentTermMatrix extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: DocumentTermMatrix);
}
export declare class TextCorpus extends PMMLObject {
    Extension?: Extension[];
    TextDocument?: TextDocument[];
    constructor(data: TextCorpus);
}
export declare class TextDictionary extends PMMLObject {
    Extension?: Extension[];
    Taxonomy?: Taxonomy;
    Array?: Array;
    constructor(data: TextDictionary);
}
export declare class TextDocument extends PMMLObject {
    Extension?: Extension[];
    id: string;
    name?: string;
    length?: number;
    file?: string;
    constructor(data: TextDocument);
}
export declare class TextModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    TextDictionary: TextDictionary;
    TextCorpus: TextCorpus;
    DocumentTermMatrix: DocumentTermMatrix;
    TextModelNormalization?: TextModelNormalization;
    TextModelSimiliarity?: TextModelSimiliarity;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    numberOfTerms: number;
    numberOfDocuments: number;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: TextModel);
}
export declare class TextModelNormalization extends PMMLObject {
    Extension?: Extension[];
    localTermWeights?: TextModelNormalizationLocalTermWeights;
    globalTermWeights?: GlobalTermWeights;
    documentNormalization?: DocumentNormalization;
    constructor(data: TextModelNormalization);
}
export declare class TextModelSimiliarity extends PMMLObject {
    Extension?: Extension[];
    similarityType?: SimilarityType;
    constructor(data: TextModelSimiliarity);
}
export declare class AR extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: AR);
}
export declare class TimeSeriesAlgorithm extends PMMLObject {
    constructor(data: TimeSeriesAlgorithm);
}
export declare class ARIMA extends TimeSeriesAlgorithm {
    Extension?: Extension[];
    NonseasonalComponent?: NonseasonalComponent;
    SeasonalComponent?: SeasonalComponent;
    DynamicRegressor?: DynamicRegressor[];
    MaximumLikelihoodStat?: MaximumLikelihoodStat;
    OutlierEffect?: OutlierEffect[];
    RMSE?: number;
    transformation?: string;
    constantTerm?: number;
    predictionMethod?: string;
    constructor(data: ARIMA);
}
export declare class ARMAPart extends PMMLObject {
    Extension?: Extension[];
    AR: AR;
    MA: MA;
    constant?: number;
    p: number;
    q: number;
    constructor(data: ARMAPart);
}
export declare class Denominator extends PMMLObject {
    Extension?: Extension[];
    NonseasonalFactor?: NonseasonalFactor;
    SeasonalFactor?: SeasonalFactor;
    constructor(data: Denominator);
}
export declare class DynamicRegressor extends PMMLObject {
    Extension?: Extension[];
    Numerator?: Numerator;
    Denominator?: Denominator;
    RegressorValues?: RegressorValues;
    field: string;
    transformation?: string;
    delay?: number;
    futureValuesMethod?: string;
    targetField?: string;
    constructor(data: DynamicRegressor);
}
export declare class ExponentialSmoothing extends TimeSeriesAlgorithm {
    Level: Level;
    Trend_ExpoSmooth?: TrendExpoSmooth;
    Seasonality_ExpoSmooth?: SeasonalityExpoSmooth;
    TimeValue?: TimeValue[];
    RMSE?: number;
    transformation?: Transformation;
    constructor(data: ExponentialSmoothing);
}
export declare class FinalNoise extends PMMLObject {
    Array?: Array;
    constructor(data: FinalNoise);
}
export declare class FinalNu extends PMMLObject {
    Array?: Array;
    constructor(data: FinalNu);
}
export declare class FinalOmega extends PMMLObject {
    Matrix: Matrix;
    constructor(data: FinalOmega);
}
export declare class FinalPredictedNoise extends PMMLObject {
    Array?: Array;
    constructor(data: FinalPredictedNoise);
}
export declare class FinalStateVector extends PMMLObject {
    Array?: Array;
    constructor(data: FinalStateVector);
}
export declare class FinalTheta extends PMMLObject {
    Theta: Theta[];
    constructor(data: FinalTheta);
}
export declare class GARCH extends TimeSeriesAlgorithm {
    Extension?: Extension[];
    ARMAPart: ARMAPart;
    GARCHPart: GARCHPart;
    constructor(data: GARCH);
}
export declare class GARCHPart extends PMMLObject {
    Extension?: Extension[];
    ResidualSquareCoefficients: ResidualSquareCoefficients;
    VarianceCoefficients: VarianceCoefficients;
    constant?: number;
    gp: number;
    gq: number;
    constructor(data: GARCHPart);
}
export declare class HVector extends PMMLObject {
    Array?: Array;
    constructor(data: HVector);
}
export declare class KalmanState extends PMMLObject {
    FinalOmega: FinalOmega;
    FinalStateVector: FinalStateVector;
    HVector?: HVector;
    constructor(data: KalmanState);
}
export declare class Level extends PMMLObject {
    alpha?: number;
    quadraticSmoothedValue?: number;
    cubicSmoothedValue?: number;
    smoothedValue?: number;
    constructor(data: Level);
}
export declare class MA extends PMMLObject {
    Extension?: Extension[];
    MACoefficients?: MACoefficients;
    Residuals?: Residuals;
    constructor(data: MA);
}
export declare class MACoefficients extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: MACoefficients);
}
export declare class MaximumLikelihoodStat extends PMMLObject {
    KalmanState?: KalmanState;
    ThetaRecursionState?: ThetaRecursionState;
    method: string;
    periodDeficit?: number;
    constructor(data: MaximumLikelihoodStat);
}
export declare class MeasurementMatrix extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: MeasurementMatrix);
}
export declare class NonseasonalComponent extends PMMLObject {
    Extension?: Extension[];
    AR?: AR;
    MA?: MA;
    p?: number;
    d?: number;
    q?: number;
    constructor(data: NonseasonalComponent);
}
export declare class NonseasonalFactor extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    difference?: number;
    maximumOrder?: number;
    constructor(data: NonseasonalFactor);
}
export declare class Numerator extends PMMLObject {
    Extension?: Extension[];
    NonseasonalFactor?: NonseasonalFactor;
    SeasonalFactor?: SeasonalFactor;
    constructor(data: Numerator);
}
export declare class OutlierEffect extends PMMLObject {
    Extension?: Extension[];
    type: string;
    startTime: number;
    magnitude: number;
    dampingCoefficient?: number;
    constructor(data: OutlierEffect);
}
export declare class PastVariances extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: PastVariances);
}
export declare class PsiVector extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    targetField?: string;
    variance?: string;
    constructor(data: PsiVector);
}
export declare class RegressorValues extends PMMLObject {
    Extension?: Extension[];
    TimeSeries?: TimeSeries;
    TrendCoefficients?: TrendCoefficients;
    TransferFunctionValues?: TransferFunctionValues;
    constructor(data: RegressorValues);
}
export declare class ResidualSquareCoefficients extends PMMLObject {
    Extension?: Extension[];
    Residuals?: Residuals;
    MACoefficients?: MACoefficients;
    constructor(data: ResidualSquareCoefficients);
}
export declare class Residuals extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: Residuals);
}
export declare class SeasonalComponent extends PMMLObject {
    Extension?: Extension[];
    AR?: AR;
    MA?: MA;
    P?: number;
    D?: number;
    Q?: number;
    period: number;
    constructor(data: SeasonalComponent);
}
export declare class SeasonalFactor extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    difference?: number;
    maximumOrder?: number;
    constructor(data: SeasonalFactor);
}
export declare class SeasonalTrendDecomposition extends TimeSeriesAlgorithm {
    constructor(data: SeasonalTrendDecomposition);
}
export declare class SeasonalityExpoSmooth extends PMMLObject {
    Array?: Array;
    type: SeasonalityExpoSmoothType;
    period: number;
    unit?: string;
    phase?: number;
    delta?: number;
    constructor(data: SeasonalityExpoSmooth);
}
export declare class SpectralAnalysis extends TimeSeriesAlgorithm {
    constructor(data: SpectralAnalysis);
}
export declare class StateSpaceModel extends TimeSeriesAlgorithm {
    Extension?: Extension[];
    StateVector?: StateVector;
    TransitionMatrix?: TransitionMatrix;
    MeasurementMatrix?: MeasurementMatrix;
    PsiVector?: PsiVector;
    DynamicRegressor?: DynamicRegressor[];
    variance?: number;
    period?: any;
    intercept?: number;
    constructor(data: StateSpaceModel);
}
export declare class StateVector extends PMMLObject {
    Extension?: Extension[];
    Array?: Array;
    constructor(data: StateVector);
}
export declare class Theta extends PMMLObject {
    i?: number;
    j?: number;
    theta?: number;
    constructor(data: Theta);
}
export declare class ThetaRecursionState extends PMMLObject {
    FinalNoise: FinalNoise;
    FinalPredictedNoise: FinalPredictedNoise;
    FinalTheta: FinalTheta;
    FinalNu: FinalNu;
    constructor(data: ThetaRecursionState);
}
export declare class TimeAnchor extends PMMLObject {
    TimeCycle?: TimeCycle[];
    TimeException?: TimeException[];
    type?: TimeAnchorType;
    offset?: number;
    stepsize?: number;
    displayName?: string;
    constructor(data: TimeAnchor);
}
export declare class TimeCycle extends PMMLObject {
    Array?: Array;
    length?: number;
    type?: TimeCycleType;
    displayName?: string;
    constructor(data: TimeCycle);
}
export declare class TimeException extends PMMLObject {
    Array?: Array;
    type?: TimeExceptionType;
    count?: number;
    constructor(data: TimeException);
}
export declare class TimeSeries extends PMMLObject {
    TimeAnchor?: TimeAnchor;
    TimeException?: TimeException[];
    TimeValue: TimeValue[];
    usage?: Usage;
    startTime?: number;
    endTime?: number;
    interpolationMethod?: InterpolationMethod;
    field?: string;
    constructor(data: TimeSeries);
}
export declare class TimeSeriesModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    LocalTransformations?: LocalTransformations;
    TimeSeries?: TimeSeries[];
    SpectralAnalysis?: SpectralAnalysis;
    ARIMA?: ARIMA;
    ExponentialSmoothing?: ExponentialSmoothing;
    SeasonalTrendDecomposition?: SeasonalTrendDecomposition;
    StateSpaceModel?: StateSpaceModel;
    GARCH?: GARCH;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    bestFit: TimeSeriesModelAlgorithm;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: TimeSeriesModel);
}
export declare class TimeValue extends PMMLObject {
    Timestamp?: Timestamp;
    index?: number;
    time?: number;
    value: number;
    standardError?: number;
    constructor(data: TimeValue);
}
export declare class TransferFunctionValues extends PMMLObject {
    Array?: Array;
    constructor(data: TransferFunctionValues);
}
export declare class TransitionMatrix extends PMMLObject {
    Extension?: Extension[];
    Matrix: Matrix;
    constructor(data: TransitionMatrix);
}
export declare class TrendCoefficients extends PMMLObject {
    Extension?: Extension[];
    "REAL-SparseArray"?: RealSparseArray;
    constructor(data: TrendCoefficients);
}
export declare class TrendExpoSmooth extends PMMLObject {
    Array?: Array;
    trend?: Trend;
    gamma?: number;
    phi?: number;
    smoothedValue?: number;
    constructor(data: TrendExpoSmooth);
}
export declare class VarianceCoefficients extends PMMLObject {
    Extension?: Extension[];
    PastVariances?: PastVariances;
    MACoefficients?: MACoefficients;
    constructor(data: VarianceCoefficients);
}
export declare class Node extends Entity<any> {
    constructor(data: Node);
}
export declare class SimpleNode extends Node {
    score?: any;
    predicate?: Predicate;
    constructor(data: SimpleNode);
}
export declare class BranchNode extends SimpleNode {
    id?: any;
    defaultChild?: any;
    nodes?: Node[];
    constructor(data: BranchNode);
}
export declare class ClassifierNode extends SimpleNode {
    id?: any;
    recordCount?: number;
    defaultChild?: any;
    scoreDistributions?: ScoreDistribution[];
    nodes?: Node[];
    constructor(data: ClassifierNode);
}
export declare class ComplexNode extends Node {
    Extension?: Extension[];
    predicate?: Predicate;
    Partition?: Partition;
    ScoreDistribution?: ScoreDistribution[];
    Node?: Node[];
    embeddedModel?: EmbeddedModel;
    id?: any;
    score?: any;
    recordCount?: number;
    defaultChild?: any;
    constructor(data: ComplexNode);
}
export declare class CountingBranchNode extends BranchNode {
    recordCount?: number;
    constructor(data: CountingBranchNode);
}
export declare class LeafNode extends SimpleNode {
    id?: any;
    constructor(data: LeafNode);
}
export declare class CountingLeafNode extends LeafNode {
    recordCount?: number;
    constructor(data: CountingLeafNode);
}
export declare class DecisionTree extends EmbeddedModel {
    Extension?: Extension[];
    Output?: Output;
    ModelStats?: ModelStats;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    ResultField?: ResultField[];
    Node: Node;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    missingValueStrategy?: DecisionTreeMissingValueStrategy;
    missingValuePenalty?: number;
    noTrueChildStrategy?: DecisionTreeNoTrueChildStrategy;
    splitCharacteristic?: DecisionTreeSplitCharacteristic;
    constructor(data: DecisionTree);
}
export interface NodeTransformer {
}
export declare class SimplifyingNodeTransformer implements NodeTransformer {
    constructor(data: SimplifyingNodeTransformer);
}
export declare class TreeModel extends Model {
    Extension?: Extension[];
    MiningSchema: MiningSchema;
    Output?: Output;
    ModelStats?: ModelStats;
    ModelExplanation?: ModelExplanation;
    Targets?: Targets;
    LocalTransformations?: LocalTransformations;
    Node: Node;
    ModelVerification?: ModelVerification;
    modelName?: string;
    functionName: MiningFunction;
    algorithmName?: string;
    missingValueStrategy?: TreeModelMissingValueStrategy;
    missingValuePenalty?: number;
    noTrueChildStrategy?: TreeModelNoTrueChildStrategy;
    splitCharacteristic?: TreeModelSplitCharacteristic;
    isScorable?: boolean;
    "x-mathContext"?: MathContext;
    constructor(data: TreeModel);
}
export declare type Function = "count" | "sum" | "average" | "min" | "max" | "multiset";
export declare type AnovaRowType = "Model" | "Error" | "Total";
export declare type ArrayType = "int" | "real" | "string";
export declare type Recursive = "no" | "yes";
export declare type CompareFunction = "absDiff" | "gaussSim" | "delta" | "equal" | "table";
export declare type ComparisonMeasureKind = "distance" | "similarity";
export declare type CompoundPredicateBooleanOperator = "or" | "and" | "xor" | "surrogate";
export declare type Cyclic = "0" | "1";
export declare type DataType = "string" | "integer" | "float" | "double" | "boolean" | "date" | "time" | "dateTime" | "dateDaysSince[0]" | "dateDaysSince[1960]" | "dateDaysSince[1970]" | "dateDaysSince[1980]" | "x-dateDaysSince[1990]" | "x-dateDaysSince[2000]" | "x-dateDaysSince[2010]" | "x-dateDaysSince[2020]" | "timeSeconds" | "dateTimeSecondsSince[0]" | "dateTimeSecondsSince[1960]" | "dateTimeSecondsSince[1970]" | "dateTimeSecondsSince[1980]" | "x-dateTimeSecondsSince[1990]" | "x-dateTimeSecondsSince[2000]" | "x-dateTimeSecondsSince[2010]" | "x-dateTimeSecondsSince[2020]";
export declare type Closure = "openClosed" | "openOpen" | "closedOpen" | "closedClosed";
export declare type InvalidValueTreatmentMethod = "returnInvalid" | "asIs" | "asMissing" | "asValue";
export declare type MathContext = "float" | "double";
export declare type MatrixKind = "diagonal" | "symmetric" | "any";
export declare type UsageType = "active" | "predicted" | "target" | "supplementary" | "group" | "order" | "frequencyWeight" | "analysisWeight";
export declare type MiningFunction = "associationRules" | "sequences" | "classification" | "regression" | "clustering" | "timeSeries" | "mixed";
export declare type MissingValueTreatmentMethod = "asIs" | "asMean" | "asMode" | "asMedian" | "asValue" | "returnInvalid";
export declare type Method = "indicator" | "thermometer";
export declare type OpType = "categorical" | "ordinal" | "continuous";
export declare type OutlierTreatmentMethod = "asIs" | "asMissingValues" | "asExtremeValues";
export declare type OutputFieldAlgorithm = "recommendation" | "exclusiveRecommendation" | "ruleAssociation";
export declare type RankBasis = "confidence" | "support" | "lift" | "leverage" | "affinity";
export declare type RankOrder = "descending" | "ascending";
export declare type RuleFeature = "antecedent" | "consequent" | "rule" | "ruleId" | "confidence" | "support" | "lift" | "leverage" | "affinity";
export declare type PartitionFieldStatsWeighted = "0" | "1";
export declare type DataUsage = "training" | "test" | "validation";
export declare type ResultFeature = "predictedValue" | "predictedDisplayValue" | "transformedValue" | "decision" | "probability" | "affinity" | "residual" | "standardError" | "standardDeviation" | "clusterId" | "clusterAffinity" | "entityId" | "entityAffinity" | "warning" | "ruleValue" | "reasonCode" | "antecedent" | "consequent" | "rule" | "ruleId" | "confidence" | "support" | "lift" | "leverage" | "x-report";
export declare type SimplePredicateOperator = "equal" | "notEqual" | "lessThan" | "lessOrEqual" | "greaterThan" | "greaterOrEqual" | "isMissing" | "isNotMissing";
export declare type SimpleSetPredicate$BooleanOperator = "isIn" | "isNotIn";
export declare type CastInteger = "round" | "ceiling" | "floor";
export declare type CountHits = "allHits" | "bestHits";
export declare type TextIndexLocalTermWeights = "termFrequency" | "binary" | "logarithmic" | "augmentedNormalizedTermFrequency";
export declare type UnivariateStatsWeighted = "0" | "1";
export declare type Property = "valid" | "invalid" | "missing";
export declare type Version = "PMML_3_0" | "PMML_3_1" | "PMML_3_2" | "PMML_4_0" | "PMML_4_1" | "PMML_4_2" | "PMML_4_3" | "PMML_4_4" | "XPMML";
export declare type TestStatistic = "zValue" | "chiSquareIndependence" | "chiSquareDistribution" | "CUSUM" | "scalarProduct";
export declare type CenterField = "true" | "false";
export declare type ModelClass = "centerBased" | "distributionBased";
export declare type CumulativeLinkFunction = "logit" | "probit" | "cloglog" | "loglog" | "cauchit";
export declare type GeneralRegressionModelDistribution = "binomial" | "gamma" | "igauss" | "negbin" | "normal" | "poisson" | "tweedie";
export declare type LinkFunction = "cloglog" | "identity" | "log" | "logc" | "logit" | "loglog" | "negbin" | "oddspower" | "power" | "probit";
export declare type GeneralRegressionModelType = "regression" | "generalLinear" | "multinomialLogistic" | "ordinalMultinomial" | "generalizedLinear" | "CoxRegression";
export declare type PCovMatrixType = "model" | "robust";
export declare type MissingPredictionTreatment = "returnMissing" | "skipSegment" | "continue";
export declare type MultipleModelMethod = "majorityVote" | "weightedMajorityVote" | "average" | "weightedAverage" | "median" | "weightedMedian" | "max" | "sum" | "weightedSum" | "selectFirst" | "selectAll" | "modelChain";
export declare type CategoricalScoringMethod = "majorityVote" | "weightedMajorityVote";
export declare type ContinuousScoringMethod = "median" | "average" | "weightedAverage";
export declare type ActivationFunction = "threshold" | "logistic" | "tanh" | "identity" | "exponential" | "reciprocal" | "square" | "Gauss" | "sine" | "cosine" | "Elliott" | "arctan" | "rectifier" | "radialBasis";
export declare type NeuralNetworkNormalizationMethod = "none" | "simplemax" | "softmax";
export declare type RegressionNormalizationMethod = "none" | "simplemax" | "softmax" | "logit" | "probit" | "cloglog" | "exp" | "loglog" | "cauchit";
export declare type RegressionModelType = "linearRegression" | "stepwisePolynomialRegression" | "logisticRegression";
export declare type RegressionModelNormalizationMethod = "none" | "simplemax" | "softmax" | "logit" | "probit" | "cloglog" | "exp" | "loglog" | "cauchit";
export declare type Criterion = "weightedSum" | "weightedMax" | "firstHit";
export declare type BaselineMethod = "max" | "min" | "mean" | "neutral" | "other";
export declare type ReasonCodeAlgorithm = "pointsAbove" | "pointsBelow";
export declare type Gap = "true" | "false" | "unknown";
export declare type TimeWindow = "sameTimeWindow" | "acrossTimeWindows";
export declare type SetPredicateOperator = "supersetOf";
export declare type ClassificationMethod = "OneAgainstAll" | "OneAgainstOne";
export declare type Representation = "SupportVectors" | "Coefficients";
export declare type DocumentNormalization = "none" | "cosine";
export declare type GlobalTermWeights = "inverseDocumentFrequency" | "none" | "GFIDF" | "normal" | "probabilisticInverse";
export declare type TextModelNormalizationLocalTermWeights = "termFrequency" | "binary" | "logarithmic" | "augmentedNormalizedTermFrequency";
export declare type SimilarityType = "euclidean" | "cosine";
export declare type Transformation = "none" | "logarithmic" | "squareroot";
export declare type SeasonalityExpoSmoothType = "additive" | "multiplicative";
export declare type TimeAnchorType = "dateTimeMillisecondsSince[0]" | "dateTimeMillisecondsSince[1960]" | "dateTimeMillisecondsSince[1970]" | "dateTimeMillisecondsSince[1980]" | "dateTimeSecondsSince[0]" | "dateTimeSecondsSince[1960]" | "dateTimeSecondsSince[1970]" | "dateTimeSecondsSince[1980]" | "dateDaysSince[0]" | "dateDaysSince[1960]" | "dateDaysSince[1970]" | "dateDaysSince[1980]" | "dateMonthsSince[0]" | "dateMonthsSince[1960]" | "dateMonthsSince[1970]" | "dateMonthsSince[1980]" | "dateYearsSince[0]";
export declare type TimeCycleType = "includeAll" | "includeFromTo" | "excludeFromTo" | "includeSet" | "excludeSet";
export declare type TimeExceptionType = "exclude" | "include";
export declare type InterpolationMethod = "none" | "linear" | "exponentialSpline" | "cubicSpline";
export declare type Usage = "original" | "logical" | "prediction";
export declare type TimeSeriesModelAlgorithm = "ARIMA" | "ExponentialSmoothing" | "SeasonalTrendDecomposition" | "SpectralAnalysis" | "StateSpaceModel" | "GARCH";
export declare type Trend = "additive" | "damped_additive" | "multiplicative" | "damped_multiplicative" | "double_exponential" | "polynomial_exponential";
export declare type DecisionTreeMissingValueStrategy = "lastPrediction" | "nullPrediction" | "defaultChild" | "weightedConfidence" | "aggregateNodes" | "none";
export declare type DecisionTreeNoTrueChildStrategy = "returnNullPrediction" | "returnLastPrediction";
export declare type DecisionTreeSplitCharacteristic = "binarySplit" | "multiSplit";
export declare type TreeModelMissingValueStrategy = "lastPrediction" | "nullPrediction" | "defaultChild" | "weightedConfidence" | "aggregateNodes" | "none";
export declare type TreeModelNoTrueChildStrategy = "returnNullPrediction" | "returnLastPrediction";
export declare type TreeModelSplitCharacteristic = "binarySplit" | "multiSplit";
//# sourceMappingURL=pmml4_4.d.ts.map