/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.livy.thriftserver.session.DataType;

public class ColumnBuffer {
    static final int DEFAULT_SIZE = 100;
    static final String EMPTY_STRING = "";
    static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final DataType type;
    private byte[] nulls;
    private int currentSize;
    private boolean[] bools;
    private byte[] bytes;
    private short[] shorts;
    private int[] ints;
    private long[] longs;
    private float[] floats;
    private double[] doubles;
    private String[] strings;
    private byte[][] buffers;

    public ColumnBuffer() {
        this.type = null;
    }

    public ColumnBuffer(DataType type) {
        this.type = type;
        switch (type) {
            case BOOLEAN: {
                this.bools = new boolean[100];
                break;
            }
            case BYTE: {
                this.bytes = new byte[100];
                break;
            }
            case SHORT: {
                this.shorts = new short[100];
                break;
            }
            case INTEGER: {
                this.ints = new int[100];
                break;
            }
            case LONG: {
                this.longs = new long[100];
                break;
            }
            case FLOAT: {
                this.floats = new float[100];
                break;
            }
            case DOUBLE: {
                this.doubles = new double[100];
                break;
            }
            case BINARY: {
                this.buffers = new byte[100][];
                break;
            }
            case STRING: {
                this.strings = new String[100];
            }
        }
    }

    private ColumnBuffer(DataType type, byte[] nulls, Object values, int currentSize) {
        this.type = type;
        this.nulls = nulls;
        this.currentSize = currentSize;
        switch (type) {
            case BOOLEAN: {
                this.bools = (boolean[])values;
                break;
            }
            case BYTE: {
                this.bytes = (byte[])values;
                break;
            }
            case SHORT: {
                this.shorts = (short[])values;
                break;
            }
            case INTEGER: {
                this.ints = (int[])values;
                break;
            }
            case LONG: {
                this.longs = (long[])values;
                break;
            }
            case FLOAT: {
                this.floats = (float[])values;
                break;
            }
            case DOUBLE: {
                this.doubles = (double[])values;
                break;
            }
            case BINARY: {
                this.buffers = (byte[][])values;
                break;
            }
            case STRING: {
                this.strings = (String[])values;
            }
        }
    }

    public DataType getType() {
        return this.type;
    }

    public Object get(int index) {
        if (index >= this.currentSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.isNull(index)) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                return this.bools[index];
            }
            case BYTE: {
                return this.bytes[index];
            }
            case SHORT: {
                return this.shorts[index];
            }
            case INTEGER: {
                return this.ints[index];
            }
            case LONG: {
                return this.longs[index];
            }
            case FLOAT: {
                return Float.valueOf(this.floats[index]);
            }
            case DOUBLE: {
                return this.doubles[index];
            }
            case BINARY: {
                return ByteBuffer.wrap(this.buffers[index]);
            }
            case STRING: {
                return this.strings[index];
            }
        }
        throw new IllegalStateException("ShouldNotReachHere()");
    }

    public int size() {
        return this.currentSize;
    }

    public void add(Object value) {
        if (value == null) {
            this.setNull(this.currentSize);
            ++this.currentSize;
            return;
        }
        this.ensureCapacity();
        switch (this.type) {
            case BOOLEAN: {
                this.bools[this.currentSize] = (Boolean)value;
                break;
            }
            case BYTE: {
                this.bytes[this.currentSize] = (Byte)value;
                break;
            }
            case SHORT: {
                this.shorts[this.currentSize] = (Short)value;
                break;
            }
            case INTEGER: {
                this.ints[this.currentSize] = (Integer)value;
                break;
            }
            case LONG: {
                this.longs[this.currentSize] = (Long)value;
                break;
            }
            case FLOAT: {
                this.floats[this.currentSize] = ((Float)value).floatValue();
                break;
            }
            case DOUBLE: {
                this.doubles[this.currentSize] = (Double)value;
                break;
            }
            case BINARY: {
                this.buffers[this.currentSize] = (byte[])value;
                break;
            }
            case STRING: {
                this.strings[this.currentSize] = (String)value;
            }
        }
        ++this.currentSize;
    }

    public Object getValues() {
        switch (this.type) {
            case BOOLEAN: {
                return this.bools.length != this.currentSize ? Arrays.copyOfRange(this.bools, 0, this.currentSize) : this.bools;
            }
            case BYTE: {
                return this.bytes.length != this.currentSize ? Arrays.copyOfRange(this.bytes, 0, this.currentSize) : this.bytes;
            }
            case SHORT: {
                return this.shorts.length != this.currentSize ? Arrays.copyOfRange(this.shorts, 0, this.currentSize) : this.shorts;
            }
            case INTEGER: {
                return this.ints.length != this.currentSize ? Arrays.copyOfRange(this.ints, 0, this.currentSize) : this.ints;
            }
            case LONG: {
                return this.longs.length != this.currentSize ? Arrays.copyOfRange(this.longs, 0, this.currentSize) : this.longs;
            }
            case FLOAT: {
                return this.floats.length != this.currentSize ? Arrays.copyOfRange(this.floats, 0, this.currentSize) : this.floats;
            }
            case DOUBLE: {
                return this.doubles.length != this.currentSize ? Arrays.copyOfRange(this.doubles, 0, this.currentSize) : this.doubles;
            }
            case BINARY: {
                return this.toList(Arrays.stream(this.buffers).map(b -> b != null ? ByteBuffer.wrap(b) : null), EMPTY_BUFFER);
            }
            case STRING: {
                return this.toList(Arrays.stream(this.strings), EMPTY_STRING);
            }
        }
        return null;
    }

    public BitSet getNulls() {
        return this.nulls != null ? BitSet.valueOf(this.nulls) : new BitSet();
    }

    public ColumnBuffer extractSubset(int end) {
        if (end > this.currentSize) {
            end = this.currentSize;
        }
        if (end < 0) {
            end = 0;
        }
        byte[] subNulls = this.getNulls().get(0, end).toByteArray();
        int split = 0;
        ColumnBuffer subset = null;
        switch (this.type) {
            case BOOLEAN: {
                split = Math.min(this.bools.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.bools, 0, split), end);
                this.bools = Arrays.copyOfRange(this.bools, split, this.bools.length);
                break;
            }
            case BYTE: {
                split = Math.min(this.bytes.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.bytes, 0, split), end);
                this.bytes = Arrays.copyOfRange(this.bytes, split, this.bytes.length);
                break;
            }
            case SHORT: {
                split = Math.min(this.shorts.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.shorts, 0, split), end);
                this.shorts = Arrays.copyOfRange(this.shorts, split, this.shorts.length);
                break;
            }
            case INTEGER: {
                split = Math.min(this.ints.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.ints, 0, split), end);
                this.ints = Arrays.copyOfRange(this.ints, split, this.ints.length);
                break;
            }
            case LONG: {
                split = Math.min(this.longs.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.longs, 0, split), end);
                this.longs = Arrays.copyOfRange(this.longs, split, this.longs.length);
                break;
            }
            case FLOAT: {
                split = Math.min(this.floats.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.floats, 0, split), end);
                this.floats = Arrays.copyOfRange(this.floats, split, this.floats.length);
                break;
            }
            case DOUBLE: {
                split = Math.min(this.doubles.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.doubles, 0, split), end);
                this.doubles = Arrays.copyOfRange(this.doubles, split, this.doubles.length);
                break;
            }
            case BINARY: {
                split = Math.min(this.buffers.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.buffers, 0, split), end);
                this.buffers = (byte[][])Arrays.copyOfRange(this.buffers, split, this.buffers.length);
                break;
            }
            case STRING: {
                split = Math.min(this.strings.length, end);
                subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.strings, 0, split), end);
                this.strings = Arrays.copyOfRange(this.strings, split, this.strings.length);
            }
        }
        this.nulls = this.getNulls().get(end, this.currentSize).toByteArray();
        this.currentSize -= end;
        return subset;
    }

    private boolean isNull(int index) {
        if (this.nulls == null) {
            return false;
        }
        int byteIdx = index / 8;
        if (byteIdx >= this.nulls.length) {
            return false;
        }
        int bitIdx = index % 8;
        return (this.nulls[byteIdx] & 1 << bitIdx) != 0;
    }

    private <T> List<T> toList(Stream<T> data, T defaultValue) {
        ArrayList ret = new ArrayList(this.currentSize);
        data.limit(this.currentSize).forEach(e -> ret.add(e != null ? e : defaultValue));
        while (ret.size() < this.currentSize) {
            ret.add(defaultValue);
        }
        return ret;
    }

    private void setNull(int index) {
        int byteIdx = index / 8;
        if (this.nulls == null) {
            this.nulls = new byte[byteIdx + 1];
        } else if (byteIdx >= this.nulls.length) {
            this.nulls = Arrays.copyOf(this.nulls, byteIdx + 1);
        }
        int bitIdx = index % 8;
        this.nulls[byteIdx] = (byte)(this.nulls[byteIdx] | 1 << bitIdx);
    }

    private void ensureCapacity() {
        int nextSize = this.currentSize + 100;
        nextSize -= nextSize % 100;
        switch (this.type) {
            case BOOLEAN: {
                if (this.bools.length > this.currentSize) break;
                this.bools = Arrays.copyOf(this.bools, nextSize);
                break;
            }
            case BYTE: {
                if (this.bytes.length > this.currentSize) break;
                this.bytes = Arrays.copyOf(this.bytes, nextSize);
                break;
            }
            case SHORT: {
                if (this.shorts.length > this.currentSize) break;
                this.shorts = Arrays.copyOf(this.shorts, nextSize);
                break;
            }
            case INTEGER: {
                if (this.ints.length > this.currentSize) break;
                this.ints = Arrays.copyOf(this.ints, nextSize);
                break;
            }
            case LONG: {
                if (this.longs.length > this.currentSize) break;
                this.longs = Arrays.copyOf(this.longs, nextSize);
                break;
            }
            case FLOAT: {
                if (this.floats.length > this.currentSize) break;
                this.floats = Arrays.copyOf(this.floats, nextSize);
                break;
            }
            case DOUBLE: {
                if (this.doubles.length > this.currentSize) break;
                this.doubles = Arrays.copyOf(this.doubles, nextSize);
                break;
            }
            case BINARY: {
                if (this.buffers.length > this.currentSize) break;
                this.buffers = (byte[][])Arrays.copyOf(this.buffers, nextSize);
                break;
            }
            case STRING: {
                if (this.strings.length > this.currentSize) break;
                this.strings = Arrays.copyOf(this.strings, nextSize);
            }
        }
    }
}

