/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.SpecialClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.MeasurementInfo;
import org.apache.iotdb.db.qp.physical.crud.QueryIndexPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;

public class QueryOperator
extends Operator {
    protected SelectComponent selectComponent;
    protected FromComponent fromComponent;
    protected WhereComponent whereComponent;
    protected SpecialClauseComponent specialClauseComponent;
    protected Map<String, Object> props;
    protected IndexType indexType;
    protected boolean enableTracing;
    Set<String> aliasSet;

    public QueryOperator() {
        super(27);
        this.operatorType = Operator.OperatorType.QUERY;
    }

    public QueryOperator(QueryOperator queryOperator) {
        this();
        this.selectComponent = queryOperator.getSelectComponent();
        this.fromComponent = queryOperator.getFromComponent();
        this.whereComponent = queryOperator.getWhereComponent();
        this.specialClauseComponent = queryOperator.getSpecialClauseComponent();
        this.props = queryOperator.getProps();
        this.indexType = queryOperator.getIndexType();
        this.enableTracing = queryOperator.isEnableTracing();
    }

    public void setAliasSet(Set<String> aliasSet) {
        this.aliasSet = aliasSet;
    }

    public Set<String> getAliasSet() {
        return this.aliasSet;
    }

    public SelectComponent getSelectComponent() {
        return this.selectComponent;
    }

    public void setSelectComponent(SelectComponent selectComponent) {
        this.selectComponent = selectComponent;
    }

    public FromComponent getFromComponent() {
        return this.fromComponent;
    }

    public void setFromComponent(FromComponent fromComponent) {
        this.fromComponent = fromComponent;
    }

    public WhereComponent getWhereComponent() {
        return this.whereComponent;
    }

    public void setWhereComponent(WhereComponent whereComponent) {
        this.whereComponent = whereComponent;
    }

    public void setSpecialClauseComponent(SpecialClauseComponent specialClauseComponent) {
        this.specialClauseComponent = specialClauseComponent;
    }

    public SpecialClauseComponent getSpecialClauseComponent() {
        return this.specialClauseComponent;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public void setProps(Map<String, Object> props) {
        this.props = props;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public boolean hasAggregationFunction() {
        return this.selectComponent.hasPlainAggregationFunction();
    }

    public boolean hasTimeSeriesGeneratingFunction() {
        return this.selectComponent.hasTimeSeriesGeneratingFunction();
    }

    public boolean isAlignByDevice() {
        return this.specialClauseComponent != null && this.specialClauseComponent.isAlignByDevice();
    }

    public boolean isAlignByTime() {
        return this.specialClauseComponent == null || this.specialClauseComponent.isAlignByTime();
    }

    public boolean isGroupByLevel() {
        return this.specialClauseComponent != null && this.specialClauseComponent.getLevels() != null;
    }

    public int[] getLevels() {
        return this.specialClauseComponent.getLevels();
    }

    public boolean hasSlimit() {
        return this.specialClauseComponent != null && this.specialClauseComponent.hasSlimit();
    }

    public boolean hasSoffset() {
        return this.specialClauseComponent != null && this.specialClauseComponent.hasSoffset();
    }

    public void resetSLimitOffset() {
        if (this.specialClauseComponent != null) {
            this.specialClauseComponent.setSeriesLimit(0);
            this.specialClauseComponent.setSeriesOffset(0);
        }
    }

    public void check() throws LogicalOperatorException {
        if (this.isAlignByDevice()) {
            if (this.selectComponent.hasTimeSeriesGeneratingFunction()) {
                throw new LogicalOperatorException("ALIGN BY DEVICE clause is not supported in UDF queries.");
            }
            for (PartialPath path : this.selectComponent.getPaths()) {
                if (path.getNodes().length <= 1) continue;
                throw new LogicalOperatorException("The paths of the SELECT clause can only be measurements or STAR.");
            }
        }
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        RawDataQueryPlan queryPlan = this.indexType == null ? new RawDataQueryPlan() : new QueryIndexPlan();
        return this.isAlignByDevice() ? this.generateAlignByDevicePlan(generator) : this.generateRawDataQueryPlan(generator, queryPlan);
    }

    protected QueryPlan generateRawDataQueryPlan(PhysicalGenerator generator, QueryPlan queryPlan) throws QueryProcessException {
        RawDataQueryPlan rawDataQueryPlan = (RawDataQueryPlan)queryPlan;
        rawDataQueryPlan.setPaths(this.selectComponent.getPaths());
        rawDataQueryPlan.setResultColumns(this.selectComponent.getResultColumns());
        rawDataQueryPlan.setEnableTracing(this.enableTracing);
        if (queryPlan instanceof QueryIndexPlan) {
            ((QueryIndexPlan)queryPlan).setIndexType(this.indexType);
            ((QueryIndexPlan)queryPlan).setProps(this.props);
            return queryPlan;
        }
        try {
            queryPlan.deduplicate(generator);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        rawDataQueryPlan.convertSpecialClauseValues(this.specialClauseComponent);
        IExpression expression = this.transformFilterOperatorToExpression();
        expression = this.optimizeExpression(expression, (RawDataQueryPlan)queryPlan);
        if (expression != null) {
            ((RawDataQueryPlan)queryPlan).setExpression(expression);
        }
        return rawDataQueryPlan;
    }

    protected IExpression transformFilterOperatorToExpression() throws QueryProcessException {
        if (this.whereComponent == null) {
            return null;
        }
        FilterOperator filterOperator = this.whereComponent.getFilterOperator();
        ArrayList<PartialPath> filterPaths = new ArrayList<PartialPath>(filterOperator.getPathSet());
        HashMap<PartialPath, TSDataType> pathTSDataTypeHashMap = new HashMap<PartialPath, TSDataType>();
        Iterator iterator = filterPaths.iterator();
        while (iterator.hasNext()) {
            PartialPath filterPath;
            pathTSDataTypeHashMap.put(filterPath, SQLConstant.isReservedPath(filterPath = (PartialPath)iterator.next()) ? TSDataType.INT64 : filterPath.getSeriesType());
        }
        return filterOperator.transformToExpression(pathTSDataTypeHashMap);
    }

    protected IExpression optimizeExpression(IExpression expression, RawDataQueryPlan queryPlan) throws QueryProcessException {
        try {
            return expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, new ArrayList<PartialPath>(queryPlan.getDeduplicatedPaths()));
        }
        catch (QueryFilterOptimizationException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    protected AlignByDevicePlan generateAlignByDevicePlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = new AlignByDevicePlan();
        List<PartialPath> devices = this.removeStarsInDeviceWithUnique(this.fromComponent.getPrefixPaths());
        List<ResultColumn> resultColumns = this.selectComponent.getResultColumns();
        List<String> aggregationFuncs = this.selectComponent.getAggregationFunctions();
        ArrayList<String> measurements = new ArrayList<String>();
        HashMap<String, MeasurementInfo> measurementInfoMap = new HashMap<String, MeasurementInfo>();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        ArrayList<String> aggregations = new ArrayList<String>();
        for (int i = 0; i < resultColumns.size(); ++i) {
            ResultColumn resultColumn = resultColumns.get(i);
            PartialPath suffixPath = this.getSuffixPathFromExpression(resultColumn.getExpression());
            String aggregation = aggregationFuncs != null ? aggregationFuncs.get(i) : null;
            LinkedHashSet<String> measurementSetOfGivenSuffix = new LinkedHashSet<String>();
            for (PartialPath device : devices) {
                PartialPath fullPath = device.concatPath(suffixPath);
                try {
                    List<MeasurementPath> actualPaths = this.getMatchedTimeseries(fullPath);
                    if (resultColumn.hasAlias() && actualPaths.size() >= 2) {
                        throw new QueryProcessException(String.format("alias %s can only be matched with one time series", resultColumn.getAlias()));
                    }
                    for (MeasurementPath path : actualPaths) {
                        MeasurementInfo measurementInfo = new MeasurementInfo(this.getMeasurementName(path, aggregation));
                        TSDataType columnDataType = SchemaUtils.getSeriesTypeByPath(path, aggregation);
                        if (aggregation != null) {
                            aggregations.add(aggregation);
                        }
                        this.checkDataTypeConsistency(columnDataType, (MeasurementInfo)measurementInfoMap.get(measurementInfo.getMeasurement()));
                        if (!measurementInfoMap.containsKey(measurementInfo.getMeasurement())) {
                            measurementInfo.setMeasurementAlias(resultColumn.hasAlias() ? resultColumn.getAlias() : null);
                            measurementInfo.setColumnDataType(columnDataType);
                            measurementInfoMap.put(measurementInfo.getMeasurement(), measurementInfo);
                        }
                        measurementSetOfGivenSuffix.add(measurementInfo.getMeasurement());
                        paths.add(path);
                    }
                }
                catch (MetadataException | QueryProcessException e) {
                    throw new QueryProcessException(e.getMessage());
                }
            }
            if (measurementSetOfGivenSuffix.isEmpty()) {
                measurements.add(suffixPath.toString());
            } else {
                measurements.addAll(measurementSetOfGivenSuffix);
            }
            if (this.specialClauseComponent.hasSlimit() && measurements.size() >= this.specialClauseComponent.getSeriesLimit() + this.specialClauseComponent.getSeriesOffset()) break;
        }
        alignByDevicePlan.setMeasurements(this.convertSpecialClauseValues(alignByDevicePlan, measurements));
        alignByDevicePlan.setPaths(paths);
        alignByDevicePlan.setAggregations(aggregations);
        alignByDevicePlan.setMeasurementInfoMap(measurementInfoMap);
        alignByDevicePlan.setEnableTracing(this.enableTracing);
        alignByDevicePlan.deduplicate(generator);
        if (this.specialClauseComponent != null) {
            alignByDevicePlan.calcWithoutNullColumnIndex(this.specialClauseComponent.withoutNullColumns);
        }
        if (this.whereComponent != null) {
            alignByDevicePlan.setDeviceToFilterMap(this.concatFilterByDevice(alignByDevicePlan, devices, this.whereComponent.getFilterOperator()));
        }
        return alignByDevicePlan;
    }

    private void checkDataTypeConsistency(TSDataType checkedDataType, MeasurementInfo measurementInfo) throws QueryProcessException {
        if (measurementInfo != null && !checkedDataType.equals((Object)measurementInfo.getColumnDataType())) {
            throw new QueryProcessException("The data types of the same measurement column should be the same across devices.");
        }
    }

    private List<String> convertSpecialClauseValues(QueryPlan queryPlan, List<String> measurements) throws QueryProcessException {
        queryPlan.convertSpecialClauseValues(this.specialClauseComponent);
        if (this.specialClauseComponent.hasSlimit()) {
            int seriesSLimit = this.specialClauseComponent.getSeriesLimit();
            int seriesOffset = this.specialClauseComponent.getSeriesOffset();
            return this.slimitTrimColumn(measurements, seriesSLimit, seriesOffset);
        }
        return measurements;
    }

    private List<PartialPath> removeStarsInDeviceWithUnique(List<PartialPath> paths) throws LogicalOptimizeException {
        ArrayList<PartialPath> retDevices;
        LinkedHashSet<PartialPath> deviceSet = new LinkedHashSet<PartialPath>();
        try {
            for (PartialPath path : paths) {
                Set<PartialPath> tempDS = this.getMatchedDevices(path);
                deviceSet.addAll(tempDS);
            }
            retDevices = new ArrayList<PartialPath>(deviceSet);
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retDevices;
    }

    private PartialPath getSuffixPathFromExpression(Expression expression) {
        return expression instanceof TimeSeriesOperand ? ((TimeSeriesOperand)expression).getPath() : ((FunctionExpression)expression).getPaths().get(0);
    }

    private String getMeasurementName(PartialPath path, String aggregation) {
        String initialMeasurement = path.getMeasurement();
        if (aggregation != null) {
            initialMeasurement = aggregation + "(" + initialMeasurement + ")";
        }
        return initialMeasurement;
    }

    private List<String> slimitTrimColumn(List<String> measurements, int seriesLimit, int seriesOffset) throws QueryProcessException {
        int size = measurements.size();
        if (seriesOffset >= size) {
            String errorMessage = "The value of SOFFSET (%d) is equal to or exceeds the number of sequences (%d) that can actually be returned.";
            throw new QueryProcessException(String.format(errorMessage, seriesOffset, size));
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        return new ArrayList<String>(measurements.subList(seriesOffset, endPosition));
    }

    private Map<String, IExpression> concatFilterByDevice(AlignByDevicePlan alignByDevicePlan, List<PartialPath> devices, FilterOperator operator) throws QueryProcessException {
        HashMap<String, IExpression> deviceToFilterMap = new HashMap<String, IExpression>();
        HashSet<PartialPath> filterPaths = new HashSet<PartialPath>();
        Iterator<PartialPath> deviceIterator = devices.iterator();
        while (deviceIterator.hasNext()) {
            FilterOperator newOperator;
            PartialPath device = deviceIterator.next();
            try {
                newOperator = operator.copy();
                this.concatFilterPath(device, newOperator, filterPaths);
            }
            catch (MetadataException | LogicalOptimizeException e) {
                deviceIterator.remove();
                alignByDevicePlan.removeDevice(device.getFullPath());
                continue;
            }
            ArrayList<PartialPath> filterPathList = new ArrayList<PartialPath>(filterPaths);
            HashMap<PartialPath, TSDataType> pathTSDataTypeHashMap = new HashMap<PartialPath, TSDataType>();
            Iterator iterator = filterPathList.iterator();
            while (iterator.hasNext()) {
                PartialPath filterPath;
                pathTSDataTypeHashMap.put(filterPath, SQLConstant.isReservedPath(filterPath = (PartialPath)iterator.next()) ? TSDataType.INT64 : filterPath.getSeriesType());
            }
            deviceToFilterMap.put(device.getFullPath(), newOperator.transformToExpression(pathTSDataTypeHashMap));
            filterPaths.clear();
        }
        return deviceToFilterMap;
    }

    private void concatFilterPath(PartialPath prefix, FilterOperator operator, Set<PartialPath> filterPaths) throws LogicalOptimizeException, MetadataException {
        if (!operator.isLeaf()) {
            for (FilterOperator child : operator.getChildren()) {
                this.concatFilterPath(prefix, child, filterPaths);
            }
            return;
        }
        FunctionOperator basicOperator = operator instanceof InOperator ? (InOperator)operator : (operator instanceof LikeOperator ? (LikeOperator)operator : (operator instanceof RegexpOperator ? (RegexpOperator)operator : (BasicFunctionOperator)operator));
        PartialPath filterPath = basicOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.getFirstNode().startsWith("root")) {
            filterPaths.add(filterPath);
            return;
        }
        PartialPath concatPath = prefix.concatPath(filterPath);
        List<MeasurementPath> concatMeasurementPaths = this.getMatchedTimeseries(concatPath);
        if (concatMeasurementPaths.isEmpty()) {
            throw new LogicalOptimizeException(String.format("Unknown time series %s in `where clause`", concatPath));
        }
        filterPaths.add(concatMeasurementPaths.get(0));
        basicOperator.setSinglePath(concatMeasurementPaths.get(0));
    }

    protected Set<PartialPath> getMatchedDevices(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getMatchedDevices(path, this.isPrefixMatchPath);
    }

    protected List<MeasurementPath> getMatchedTimeseries(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getMeasurementPaths(path, this.isPrefixMatchPath);
    }

    public boolean isEnableTracing() {
        return this.enableTracing;
    }

    public void setEnableTracing(boolean enableTracing) {
        this.enableTracing = enableTracing;
    }
}

