/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.service.IoTDB;

public interface PartitionTable {
    public PartitionGroup route(String var1, long var2);

    public RaftNode routeToHeaderByTime(String var1, long var2);

    public void addNode(Node var1);

    public NodeAdditionResult getNodeAdditionResult(Node var1);

    public void removeNode(Node var1);

    public NodeRemovalResult getNodeRemovalResult();

    public List<PartitionGroup> getLocalGroups();

    public PartitionGroup getPartitionGroup(RaftNode var1);

    public ByteBuffer serialize();

    public boolean deserialize(ByteBuffer var1);

    public List<Node> getAllNodes();

    public List<PartitionGroup> getGlobalGroups();

    public List<PartitionGroup> calculateGlobalGroups(List<Node> var1);

    public long getLastMetaLogIndex();

    public void setLastMetaLogIndex(long var1);

    default public PartitionGroup partitionByPathTime(PartialPath path, long timestamp) throws MetadataException {
        PartialPath storageGroup = IoTDB.metaManager.getBelongedStorageGroup(path);
        return this.route(storageGroup.getFullPath(), timestamp);
    }

    default public MultiKeyMap<Long, PartitionGroup> partitionByPathRangeTime(PartialPath path, long startTime, long endTime) throws MetadataException {
        long partitionInterval = StorageEngine.getTimePartitionInterval();
        MultiKeyMap timeRangeMapRaftGroup = new MultiKeyMap();
        PartialPath storageGroup = IoTDB.metaManager.getBelongedStorageGroup(path);
        startTime = DateTimeUtils.convertMilliTimeWithPrecision((long)startTime);
        endTime = DateTimeUtils.convertMilliTimeWithPrecision((long)endTime);
        while (startTime <= endTime) {
            long nextTime = (startTime / partitionInterval + 1L) * partitionInterval;
            timeRangeMapRaftGroup.put((Object)startTime, (Object)Math.min(nextTime - 1L, endTime), (Object)this.route(storageGroup.getFullPath(), startTime));
            startTime = nextTime;
        }
        return timeRangeMapRaftGroup;
    }
}

