/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.api.customizer.parameter;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.exception.UDFAttributeNotProvidedException;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesIndexNotValidException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesNumberNotValidException;
import org.apache.iotdb.db.query.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDFParameterValidator {
    private final UDFParameters parameters;

    public UDFParameterValidator(UDFParameters parameters) {
        this.parameters = parameters;
    }

    public UDFParameters getParameters() {
        return this.parameters;
    }

    public UDFParameterValidator validateRequiredAttribute(String attributeKey) throws UDFAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(attributeKey)) {
            throw new UDFAttributeNotProvidedException(attributeKey);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesDataType(int index, TSDataType expectedDataType) throws UDFException {
        TSDataType actualDataType;
        this.validateInputSeriesIndex(index);
        try {
            actualDataType = this.parameters.getDataType(index);
        }
        catch (MetadataException e) {
            throw new UDFException("error occurred when getting the data type of the input series");
        }
        if (!expectedDataType.equals((Object)actualDataType)) {
            throw new UDFInputSeriesDataTypeNotValidException(index, actualDataType, expectedDataType);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesDataType(int index, TSDataType ... expectedDataTypes) throws UDFException {
        TSDataType actualDataType;
        this.validateInputSeriesIndex(index);
        try {
            actualDataType = this.parameters.getDataType(index);
        }
        catch (MetadataException e) {
            throw new UDFException("error occurred when getting the data type of the input series");
        }
        for (TSDataType expectedDataType : expectedDataTypes) {
            if (!expectedDataType.equals((Object)actualDataType)) continue;
            return this;
        }
        throw new UDFInputSeriesDataTypeNotValidException(index, actualDataType, expectedDataTypes);
    }

    public UDFParameterValidator validateInputSeriesNumber(int expectedSeriesNumber) throws UDFInputSeriesNumberNotValidException {
        int actualSeriesNumber = this.parameters.getPaths().size();
        if (actualSeriesNumber != expectedSeriesNumber) {
            throw new UDFInputSeriesNumberNotValidException(actualSeriesNumber, expectedSeriesNumber);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesNumber(int expectedSeriesNumberLowerBound, int expectedSeriesNumberUpperBound) throws UDFInputSeriesNumberNotValidException {
        int actualSeriesNumber = this.parameters.getPaths().size();
        if (actualSeriesNumber < expectedSeriesNumberLowerBound || expectedSeriesNumberUpperBound < actualSeriesNumber) {
            throw new UDFInputSeriesNumberNotValidException(actualSeriesNumber, expectedSeriesNumberLowerBound, expectedSeriesNumberUpperBound);
        }
        return this;
    }

    public UDFParameterValidator validate(SingleObjectValidationRule validationRule, String messageToThrow, Object argument) throws UDFParameterNotValidException {
        if (!validationRule.validate(argument)) {
            throw new UDFParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public UDFParameterValidator validate(MultipleObjectsValidationRule validationRule, String messageToThrow, Object ... arguments) throws UDFParameterNotValidException {
        if (!validationRule.validate(arguments)) {
            throw new UDFParameterNotValidException(messageToThrow);
        }
        return this;
    }

    private void validateInputSeriesIndex(int index) throws UDFInputSeriesIndexNotValidException {
        int actualSeriesNumber = this.parameters.getPaths().size();
        if (index < 0 || actualSeriesNumber <= index) {
            throw new UDFInputSeriesIndexNotValidException(index, actualSeriesNumber);
        }
    }

    public static interface MultipleObjectsValidationRule {
        public boolean validate(Object ... var1);
    }

    public static interface SingleObjectValidationRule {
        public boolean validate(Object var1);
    }
}

