/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferSliceReq
extends TPipeTransferReq {
    private transient int orderId;
    private transient short originReqType;
    private transient int originBodySize;
    private transient byte[] sliceBody;
    private transient int sliceIndex;
    private transient int sliceCount;

    public int getOrderId() {
        return this.orderId;
    }

    public short getOriginReqType() {
        return this.originReqType;
    }

    public int getOriginBodySize() {
        return this.originBodySize;
    }

    public byte[] getSliceBody() {
        return this.sliceBody;
    }

    public int getSliceIndex() {
        return this.sliceIndex;
    }

    public int getSliceCount() {
        return this.sliceCount;
    }

    public static PipeTransferSliceReq toTPipeTransferReq(int orderId, short originReqType, int sliceIndex, int sliceCount, ByteBuffer duplicatedOriginBody, int startIndexInBody, int endIndexInBody) throws IOException {
        PipeTransferSliceReq sliceReq = new PipeTransferSliceReq();
        sliceReq.orderId = orderId;
        sliceReq.originReqType = originReqType;
        sliceReq.originBodySize = duplicatedOriginBody.limit();
        sliceReq.sliceBody = new byte[endIndexInBody - startIndexInBody];
        duplicatedOriginBody.position(startIndexInBody);
        duplicatedOriginBody.get(sliceReq.sliceBody);
        sliceReq.sliceIndex = sliceIndex;
        sliceReq.sliceCount = sliceCount;
        sliceReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        sliceReq.type = PipeRequestType.TRANSFER_SLICE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)sliceReq.orderId, (OutputStream)outputStream);
            ReadWriteIOUtils.write((short)sliceReq.originReqType, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)sliceReq.originBodySize, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Binary)new Binary(sliceReq.sliceBody), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)sliceReq.sliceIndex, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)sliceReq.sliceCount, (OutputStream)outputStream);
            sliceReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return sliceReq;
    }

    public static PipeTransferSliceReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferSliceReq sliceReq = new PipeTransferSliceReq();
        sliceReq.orderId = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        sliceReq.originReqType = ReadWriteIOUtils.readShort((ByteBuffer)transferReq.body);
        sliceReq.originBodySize = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        sliceReq.sliceBody = ReadWriteIOUtils.readBinary((ByteBuffer)transferReq.body).getValues();
        sliceReq.sliceIndex = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        sliceReq.sliceCount = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        sliceReq.version = transferReq.version;
        sliceReq.type = transferReq.type;
        return sliceReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferSliceReq that = (PipeTransferSliceReq)((Object)obj);
        return Objects.equals(this.orderId, that.orderId) && Objects.equals(this.originReqType, that.originReqType) && Objects.equals(this.originBodySize, that.originBodySize) && Arrays.equals(this.sliceBody, that.sliceBody) && Objects.equals(this.sliceIndex, that.sliceIndex) && Objects.equals(this.sliceCount, that.sliceCount) && Objects.equals(this.version, that.version) && Objects.equals(this.type, that.type) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.originReqType, this.originBodySize, Arrays.hashCode(this.sliceBody), this.sliceIndex, this.sliceCount, this.version, this.type, this.body);
    }
}

