/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Objects;
import org.apache.tsfile.block.column.Column;

public class ColumnUtil {
    private static final double BLOCK_RESET_SKEW = 1.25;
    private static final int DEFAULT_CAPACITY = 64;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private ColumnUtil() {
    }

    static void checkArrayRange(int[] array, int offset, int length) {
        Objects.requireNonNull(array, "array is null");
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and length %s in array with %s elements", offset, length, array.length));
        }
    }

    static void checkValidRegion(int positionCount, int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in block with %s positions", positionOffset, length, positionCount));
        }
    }

    static void checkValidPositions(boolean[] positions, int positionCount) {
        if (positions.length != positionCount) {
            throw new IllegalArgumentException(String.format("Invalid positions array size %d, actual position count is %d", positions.length, positionCount));
        }
    }

    static void checkValidPosition(int position, int positionCount) {
        if (position < 0 || position >= positionCount) {
            throw new IllegalArgumentException(String.format("Invalid position %s in block with %s positions", position, positionCount));
        }
    }

    static void checkReadablePosition(Column column, int position) {
        ColumnUtil.checkValidPosition(position, column.getPositionCount());
    }

    static int[] compactArray(int[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static int calculateNewArraySize(int currentSize) {
        long newSize = (long)currentSize + (long)(currentSize >> 1);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L && (newSize = 0x7FFFFFF7L) == (long)currentSize) {
            throw new IllegalArgumentException(String.format("Cannot grow array beyond '%s'", 0x7FFFFFF7));
        }
        return (int)newSize;
    }

    static int calculateBlockResetSize(int currentSize) {
        long newSize = (long)Math.ceil((double)currentSize * 1.25);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L) {
            newSize = 0x7FFFFFF7L;
        }
        return (int)newSize;
    }
}

