/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.gapfill;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

abstract class AbstractGapFillOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AbstractGapFillOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    protected final int outputColumnCount;
    private final int timeColumnIndex;
    private final TsBlockBuilder resultBuilder;
    private final long startTime;
    private final long endTime;
    protected long currentTime;
    private SortKey lastGroupKey = null;

    AbstractGapFillOperator(OperatorContext operatorContext, Operator child, int timeColumnIndex, long startTime, long endTime, List<TSDataType> dataTypes) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.outputColumnCount = dataTypes.size();
        this.timeColumnIndex = timeColumnIndex;
        this.startTime = startTime;
        this.currentTime = startTime;
        this.endTime = endTime;
        this.resultBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.child.hasNextWithTimer()) {
            if (this.hasRemainingGapInPreviousGroup()) {
                this.resultBuilder.reset();
                this.fillGaps(this.lastGroupKey.tsBlock, this.lastGroupKey.rowIndex, this.endTime);
                return this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
            }
            return null;
        }
        TsBlock block = this.child.nextWithTimer();
        if (block == null || block.isEmpty()) {
            return null;
        }
        Preconditions.checkArgument((this.outputColumnCount == block.getValueColumnCount() ? 1 : 0) != 0, (Object)"outputColumnCount is not equal to value column count of child operator's TsBlock");
        this.resultBuilder.reset();
        SortKey previousGroupKey = this.lastGroupKey;
        int size = block.getPositionCount();
        for (int i = 0; i < size; ++i) {
            SortKey currentGroupKey = new SortKey(block, i);
            if (this.isNewGroup(currentGroupKey, previousGroupKey)) {
                if (this.currentTime <= this.endTime) {
                    this.fillGaps(previousGroupKey.tsBlock, previousGroupKey.rowIndex, this.endTime);
                }
                this.resetTimeIterator();
                previousGroupKey = currentGroupKey;
            } else if (previousGroupKey == null) {
                previousGroupKey = currentGroupKey;
            }
            Column timeColumn = block.getColumn(this.timeColumnIndex);
            long currentEndTime = timeColumn.isNull(i) ? this.endTime : block.getColumn(this.timeColumnIndex).getLong(i) - 1L;
            this.fillGaps(block, i, currentEndTime);
            this.writeCurrentRow(block, i);
        }
        this.lastGroupKey = new SortKey(block, size - 1);
        return this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
    }

    private void resetTimeIterator() {
        this.currentTime = this.startTime;
    }

    private void writeCurrentRow(TsBlock block, int rowIndex) {
        this.resultBuilder.declarePosition();
        for (int i = 0; i < this.outputColumnCount; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            Column column = block.getColumn(i);
            if (column.isNull(rowIndex)) {
                columnBuilder.appendNull();
                continue;
            }
            columnBuilder.write(column, rowIndex);
        }
        this.nextTime();
    }

    private void fillGaps(TsBlock block, int rowIndex, long currentEndTime) {
        while (this.currentTime <= currentEndTime) {
            this.gapFillRow(this.currentTime, block, rowIndex);
            this.nextTime();
        }
    }

    private void gapFillRow(long time, TsBlock block, int rowIndex) {
        this.resultBuilder.declarePosition();
        for (int i = 0; i < this.outputColumnCount; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            if (i == this.timeColumnIndex) {
                columnBuilder.writeLong(time);
                continue;
            }
            if (this.isGroupKeyColumn(i)) {
                Column column = block.getColumn(i);
                if (column.isNull(rowIndex)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(column, rowIndex);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    abstract boolean isNewGroup(SortKey var1, SortKey var2);

    abstract boolean isGroupKeyColumn(int var1);

    abstract void nextTime();

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        this.lastGroupKey = null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished() && !this.hasRemainingGapInPreviousGroup();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer() || this.hasRemainingGapInPreviousGroup();
    }

    private boolean hasRemainingGapInPreviousGroup() {
        return this.lastGroupKey != null && this.currentTime < this.endTime;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 2L * this.child.calculateMaxPeekMemory() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

