/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.MutableFloatKeysMap;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

public abstract class AbstractMutableFloatKeySet
implements MutableFloatSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !AbstractMutableFloatKeySet.isEmptyKey(key) && !AbstractMutableFloatKeySet.isRemovedKey(key);
    }

    protected abstract float getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableFloatKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    @Override
    public void each(FloatProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0f)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0f)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0f)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0f)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0f)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0f)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(float element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(float ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(FloatIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatSet select(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0f)) {
                result.add(0.0f);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0f)) {
                result.add(1.0f);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableFloatSet reject(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0f)) {
                result.add(0.0f);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0f)) {
                result.add(1.0f);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableFloatSet with(float element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatSet without(float element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatSet withAll(FloatIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatSet withoutAll(FloatIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf(0.0f));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf(1.0f));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    @Override
    public boolean remove(float key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(FloatIterable source) {
        int oldSize = this.getOuter().size();
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            this.getOuter().removeKey(iterator.next());
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(float ... source) {
        int oldSize = this.getOuter().size();
        for (float item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public void clear() {
        this.getOuter().clear();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0f)) {
                return 0.0f;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0f)) {
                return 1.0f;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    @Override
    public MutableFloatSet asUnmodifiable() {
        return UnmodifiableFloatSet.of(this);
    }

    @Override
    public MutableFloatSet asSynchronized() {
        return SynchronizedFloatSet.of(this);
    }

    @Override
    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        if (this.getSentinelValues() != null) {
            double nextSum;
            double adjustedValue;
            if (this.getSentinelValues().containsZeroKey) {
                adjustedValue = 0.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            if (this.getSentinelValues().containsOneKey) {
                adjustedValue = 1.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            double adjustedValue = (double)this.getKeyAtIndex(i) - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    @Override
    public float max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 0.0f;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max = 0.0f;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max = 1.0f;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && Float.compare(max, this.getKeyAtIndex(i)) >= 0) continue;
            max = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public float min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        float min2 = 0.0f;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min2 = 0.0f;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min2 = 1.0f;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && Float.compare(this.getKeyAtIndex(i), min2) >= 0) continue;
            min2 = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newList(this).sortThis();
    }

    @Override
    public float[] toArray() {
        int size = this.getOuter().size();
        final float[] result = new float[size];
        this.getOuter().forEachKey(new FloatProcedure(){
            private int index;

            @Override
            public void value(float each) {
                result[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public float[] toArray(float[] result) {
        int size = this.getOuter().size();
        if (result.length < size) {
            result = new float[size];
        }
        final float[] finalBypass = result;
        this.getOuter().forEachKey(new FloatProcedure(){
            private int index;

            @Override
            public void value(float each) {
                finalBypass[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public boolean contains(float value) {
        return this.getOuter().containsKey(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.getOuter().containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LazyIterable<FloatFloatPair> cartesianProduct(FloatSet set) {
        return FloatSets.cartesianProduct(this, set);
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newList(this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSet(this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBag(this);
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, 0.0f);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, 1.0f);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public ImmutableFloatSet toImmutable() {
        return FloatSets.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.getOuter().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet other = (FloatSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += Float.floatToIntBits(0.0f);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += Float.floatToIntBits(1.0f);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += Float.floatToIntBits(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0.0f));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0f));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableFloatKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<FloatIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(FloatSets.mutable.withAll(this));
            } else {
                MutableFloatIterator iterator = this.floatIterator();
                while (iterator.hasNext()) {
                    MutableFloatSet batch = FloatSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerRep(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static class SerRep
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private transient AbstractMutableFloatKeySet original;
        private transient FloatHashSet deserialized;

        public SerRep() {
        }

        private SerRep(AbstractMutableFloatKeySet original) {
            this.original = original;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original.size());
            MutableFloatIterator it = this.original.floatIterator();
            while (it.hasNext()) {
                out.writeFloat(it.next());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int unread;
            this.deserialized = new FloatHashSet(unread);
            for (unread = in.readInt(); unread > 0; --unread) {
                this.deserialized.add(in.readFloat());
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.deserialized;
        }
    }
}

