/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.AlterPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.OperateMultiplePipesPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.metric.overview.PipeTemporaryMetaInCoordinatorMetrics;
import org.apache.iotdb.confignode.persistence.pipe.PipePluginInfo;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInfo.class);
    private final PipePluginInfo pipePluginInfo = new PipePluginInfo();
    private final PipeTaskInfo pipeTaskInfo = new PipeTaskInfo();

    public PipePluginInfo getPipePluginInfo() {
        return this.pipePluginInfo;
    }

    public PipeTaskInfo getPipeTaskInfo() {
        return this.pipeTaskInfo;
    }

    public TSStatus createPipe(CreatePipePlanV2 plan) {
        try {
            Optional<PipeMeta> pipeMetaBeforeCreation = Optional.ofNullable(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeStaticMeta().getPipeName()));
            this.pipeTaskInfo.createPipe(plan);
            TPushPipeMetaRespExceptionMessage message = PipeConfigNodeAgent.task().handleSinglePipeMetaChanges(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeStaticMeta().getPipeName()));
            if (message == null) {
                pipeMetaBeforeCreation.orElseGet(() -> {
                    try {
                        PipeConfigNodeAgent.runtime().increaseListenerReference(plan.getPipeStaticMeta().getSourceParameters());
                        return null;
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to increase listener reference", (Throwable)e);
                    }
                });
                PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(message.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create pipe", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to create pipe, because " + e.getMessage());
        }
    }

    public TSStatus setPipeStatus(SetPipeStatusPlanV2 plan) {
        try {
            this.pipeTaskInfo.setPipeStatus(plan);
            PipeConfigNodeAgent.task().handleSinglePipeMetaChanges(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeName()));
            PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("Failed to set pipe status", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to set pipe status, because " + e.getMessage());
        }
    }

    public TSStatus dropPipe(DropPipePlanV2 plan) {
        try {
            Optional<PipeMeta> pipeMetaBeforeDrop = Optional.ofNullable(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeName()));
            this.pipeTaskInfo.dropPipe(plan);
            TPushPipeMetaRespExceptionMessage message = PipeConfigNodeAgent.task().handleDropPipe(plan.getPipeName());
            if (message == null) {
                pipeMetaBeforeDrop.ifPresent(meta -> {
                    try {
                        PipeConfigNodeAgent.runtime().decreaseListenerReference(meta.getStaticMeta().getSourceParameters());
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to decrease listener reference", (Throwable)e);
                    }
                });
                PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(message.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to drop pipe", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to drop pipe, because " + e.getMessage());
        }
    }

    public TSStatus alterPipe(AlterPipePlanV2 plan) {
        try {
            Optional<PipeMeta> pipeMetaBeforeAlter = Optional.ofNullable(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeStaticMeta().getPipeName()));
            this.pipeTaskInfo.alterPipe(plan);
            TPushPipeMetaRespExceptionMessage message = PipeConfigNodeAgent.task().handleSinglePipeMetaChanges(this.pipeTaskInfo.getPipeMetaByPipeName(plan.getPipeStaticMeta().getPipeName()));
            if (message == null) {
                PipeConfigNodeAgent.runtime().increaseListenerReference(plan.getPipeStaticMeta().getSourceParameters());
                pipeMetaBeforeAlter.ifPresent(meta -> {
                    try {
                        PipeConfigNodeAgent.runtime().decreaseListenerReference(meta.getStaticMeta().getSourceParameters());
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to decrease listener reference", (Throwable)e);
                    }
                });
                PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(message.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to alter pipe", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to alter pipe, because " + e.getMessage());
        }
    }

    public TSStatus operateMultiplePipes(OperateMultiplePipesPlanV2 plans) {
        try {
            TSStatus status = this.pipeTaskInfo.operateMultiplePipes(plans);
            PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
            return status;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create multiple pipes", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to create multiple pipes, because " + e.getMessage());
        }
    }

    public TSStatus handleLeaderChange(PipeHandleLeaderChangePlan plan) {
        try {
            this.pipeTaskInfo.handleLeaderChange(plan);
            ArrayList<PipeMeta> pipeMetaListFromCoordinator = new ArrayList<PipeMeta>();
            for (PipeMeta pipeMeta : this.pipeTaskInfo.getPipeMetaList()) {
                pipeMetaListFromCoordinator.add(pipeMeta);
            }
            PipeConfigNodeAgent.task().handlePipeMetaChanges(pipeMetaListFromCoordinator);
            PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle leader change", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to handle leader change, because " + e.getMessage());
        }
    }

    public TSStatus handleMetaChanges(PipeHandleMetaChangePlan plan) {
        try {
            this.pipeTaskInfo.handleMetaChanges(plan);
            ArrayList<PipeMeta> pipeMetaListFromCoordinator = new ArrayList<PipeMeta>();
            for (PipeMeta pipeMeta : plan.getPipeMetaList()) {
                pipeMetaListFromCoordinator.add(this.pipeTaskInfo.getPipeMetaByPipeName(pipeMeta.getStaticMeta().getPipeName()));
            }
            PipeConfigNodeAgent.task().handlePipeMetaChanges(pipeMetaListFromCoordinator);
            PipeTemporaryMetaInCoordinatorMetrics.getInstance().handleTemporaryMetaChanges(this.pipeTaskInfo.getPipeMetaList());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle meta changes", (Throwable)e);
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage("Failed to handle meta changes, because " + e.getMessage());
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return this.pipeTaskInfo.processTakeSnapshot(snapshotDir) && this.pipePluginInfo.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        Exception loadPipeTaskInfoException = null;
        Exception loadPipePluginInfoException = null;
        try {
            this.pipeTaskInfo.processLoadSnapshot(snapshotDir);
            for (PipeMeta pipeMeta : this.pipeTaskInfo.getPipeMetaList()) {
                PipeConfigNodeAgent.runtime().increaseListenerReference(pipeMeta.getStaticMeta().getSourceParameters());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load pipe task info from snapshot", (Throwable)ex);
            loadPipeTaskInfoException = ex;
        }
        try {
            this.pipePluginInfo.processLoadSnapshot(snapshotDir);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load pipe plugin info from snapshot", (Throwable)ex);
            loadPipePluginInfoException = ex;
        }
        if (loadPipeTaskInfoException != null || loadPipePluginInfoException != null) {
            throw new IOException("Failed to load pipe info from snapshot, loadPipeTaskInfoException=" + loadPipeTaskInfoException + ", loadPipePluginInfoException=" + loadPipePluginInfoException);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeInfo that = (PipeInfo)o;
        return Objects.equals(this.pipePluginInfo, that.pipePluginInfo) && Objects.equals(this.pipeTaskInfo, that.pipeTaskInfo);
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginInfo, this.pipeTaskInfo);
    }

    public String toString() {
        return "PipeInfo{pipePluginInfo=" + this.pipePluginInfo + ", pipeTaskInfo=" + this.pipeTaskInfo + '}';
    }
}

