/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.internal.core.cql.EmptyColumnDefinitions;
import com.datastax.oss.driver.internal.core.data.IdentifierIndex;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultColumnDefinitions
implements ColumnDefinitions,
Serializable {
    private final List<ColumnDefinition> definitions;
    private final IdentifierIndex index;

    public static ColumnDefinitions valueOf(List<ColumnDefinition> definitions) {
        return definitions.isEmpty() ? EmptyColumnDefinitions.INSTANCE : new DefaultColumnDefinitions(definitions);
    }

    private DefaultColumnDefinitions(List<ColumnDefinition> definitions) {
        assert (definitions != null && definitions.size() > 0);
        this.definitions = definitions;
        this.index = DefaultColumnDefinitions.buildIndex(definitions);
    }

    @Override
    public int size() {
        return this.definitions.size();
    }

    @Override
    @NonNull
    public ColumnDefinition get(int i) {
        return this.definitions.get(i);
    }

    @Override
    @NonNull
    public Iterator<ColumnDefinition> iterator() {
        return this.definitions.iterator();
    }

    @Override
    public boolean contains(@NonNull String name) {
        return this.index.firstIndexOf(name) >= 0;
    }

    @Override
    public boolean contains(@NonNull CqlIdentifier id) {
        return this.index.firstIndexOf(id) >= 0;
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull String name) {
        return this.index.allIndicesOf(name);
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        return this.index.firstIndexOf(name);
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull CqlIdentifier id) {
        return this.index.allIndicesOf(id);
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        return this.index.firstIndexOf(id);
    }

    @Override
    public boolean isDetached() {
        return this.definitions.get(0).isDetached();
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        for (ColumnDefinition definition : this.definitions) {
            definition.attach(attachmentPoint);
        }
    }

    private static IdentifierIndex buildIndex(List<ColumnDefinition> definitions) {
        ArrayList<CqlIdentifier> identifiers = new ArrayList<CqlIdentifier>(definitions.size());
        for (ColumnDefinition definition : definitions) {
            identifiers.add(definition.getName());
        }
        return new IdentifierIndex(identifiers);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<ColumnDefinition> definitions;

        private SerializationProxy(DefaultColumnDefinitions columnDefinitions) {
            this.definitions = columnDefinitions.definitions;
        }

        private Object readResolve() {
            return new DefaultColumnDefinitions(this.definitions);
        }
    }
}

