/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSimpleBindRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSimpleBindResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSimpleBindOperation
extends InterceptedOperation
implements InMemoryInterceptedSimpleBindRequest,
InMemoryInterceptedSimpleBindResult {
    @NotNull
    private BindResult bindResult;
    @Nullable
    private SimpleBindRequest bindRequest;

    InterceptedSimpleBindOperation(@NotNull LDAPListenerClientConnection clientConnection, int messageID, @NotNull BindRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.bindRequest = (SimpleBindRequest)requestOp.toBindRequest(requestControls);
        this.bindResult = null;
    }

    @Override
    @NotNull
    public SimpleBindRequest getRequest() {
        return this.bindRequest;
    }

    @Override
    public void setRequest(@NotNull SimpleBindRequest bindRequest) {
        this.bindRequest = bindRequest;
    }

    @Override
    @Nullable
    public BindResult getResult() {
        return this.bindResult;
    }

    @Override
    public void setResult(@NotNull BindResult bindResult) {
        this.bindResult = bindResult;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedSimpleBindOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.bindRequest);
        buffer.append(", result=");
        buffer.append(this.bindResult);
        buffer.append(')');
    }
}

