/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryExecutionException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class OverloadedException
extends QueryExecutionException {
    public OverloadedException(@NonNull Node coordinator) {
        super(coordinator, String.format("%s is overloaded", coordinator), null, false);
    }

    public OverloadedException(@NonNull Node coordinator, @NonNull String message) {
        super(coordinator, String.format("%s is overloaded: %s", coordinator, message), null, false);
    }

    private OverloadedException(@NonNull Node coordinator, @NonNull String message, @Nullable ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, executionInfo, writableStackTrace);
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new OverloadedException(this.getCoordinator(), this.getMessage(), this.getExecutionInfo(), true);
    }
}

