/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.core.Strings;

final class JsonStringImpl
implements JsonString,
Serializable {
    private final String value;
    private String escape;
    private transient Integer hashCode = null;

    JsonStringImpl(String value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    public CharSequence getChars() {
        return this.value;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.STRING;
    }

    public String toString() {
        String s = this.escape;
        if (s == null) {
            this.escape = s = '\"' + Strings.escape(this.value) + '\"';
        }
        return s;
    }

    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        return JsonString.class.isInstance(obj) && ((JsonString)JsonString.class.cast(obj)).getString().equals(this.value);
    }
}

