/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.avl;

import java.net.URI;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlMasterTable;
import org.apache.directory.server.xdbm.impl.avl.AvlRdnIndex;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlPartition
extends AbstractBTreePartition {
    private static final Logger LOG = LoggerFactory.getLogger(AvlPartition.class);

    public AvlPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    public AvlPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
    }

    @Override
    protected void doRepair() throws Exception {
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.initialized) {
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this, this.schemaManager);
            CursorBuilder cursorBuilder = new CursorBuilder(this, evaluatorBuilder);
            if (!this.optimizerEnabled) {
                this.setOptimizer(new NoOpOptimizer());
            } else {
                this.setOptimizer(new DefaultOptimizer(this));
            }
            this.setSearchEngine(new DefaultSearchEngine(this, cursorBuilder, evaluatorBuilder, this.getOptimizer()));
            if (this.isInitialized()) {
                return;
            }
            this.master = new AvlMasterTable(this.id, UuidComparator.INSTANCE, null, false);
            super.doInit();
        }
    }

    public String getDefaultId() {
        return Partition.DEFAULT_ID;
    }

    public String getRootId() {
        return Partition.ROOT_ID;
    }

    @Override
    public void sync() throws Exception {
    }

    @Override
    public boolean isSyncOnWrite() {
        return false;
    }

    @Override
    public int getCacheSize() {
        return 0;
    }

    @Override
    protected Index<?, String> convertAndInit(Index<?, String> index) throws Exception {
        AvlIndex avlIndex;
        if (index.getAttributeId().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            avlIndex = new AvlRdnIndex(index.getAttributeId());
        } else if (index instanceof AvlIndex) {
            avlIndex = (AvlIndex)index;
        } else {
            LOG.debug("Supplied index {} is not a AvlIndex. Will create new AvlIndex using copied configuration parameters.", (Object)index);
            avlIndex = new AvlIndex(index.getAttributeId(), true);
        }
        ((AvlIndex)avlIndex).init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return avlIndex;
    }

    @Override
    protected final Index createSystemIndex(String oid, URI path, boolean withReverse) throws Exception {
        AvlIndex avlIndex;
        LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.");
        if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            avlIndex = new AvlRdnIndex(oid);
        } else {
            LOG.debug("Supplied index {} is not a AvlIndex. Will create new AvlIndex using copied configuration parameters.");
            avlIndex = new AvlIndex(oid, withReverse);
        }
        return avlIndex;
    }

    @Override
    public URI getPartitionPath() {
        return null;
    }
}

