/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.api.ldap.model.name.Rdn;

public class ParentIdAndRdn
implements Externalizable,
Comparable<ParentIdAndRdn> {
    protected String parentId;
    protected Rdn[] rdns;
    protected int nbChildren;
    protected int nbDescendants;

    public ParentIdAndRdn() {
    }

    public ParentIdAndRdn(String parentId, Rdn ... rdns) {
        this.parentId = parentId;
        this.rdns = rdns;
    }

    public ParentIdAndRdn(String parentId, List<Rdn> rdns) {
        this.parentId = parentId;
        this.rdns = rdns.toArray(new Rdn[rdns.size()]);
        this.nbChildren = 0;
        this.nbDescendants = 0;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Rdn[] getRdns() {
        return this.rdns;
    }

    public void setRdns(Rdn ... rdns) {
        this.rdns = rdns;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + (this.parentId == null ? 0 : this.parentId.hashCode());
        h = h * 17 + Arrays.hashCode(this.rdns);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParentIdAndRdn)) {
            return false;
        }
        ParentIdAndRdn that = (ParentIdAndRdn)obj;
        if (this.rdns == null) {
            return that.rdns == null;
        }
        if (that.rdns == null) {
            return false;
        }
        if (this.rdns.length != that.rdns.length) {
            return false;
        }
        for (int i = 0; i < this.rdns.length; ++i) {
            if (this.rdns[i].equals(that.rdns[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ParentIdAndRdn that) {
        if (that.rdns == null) {
            int val = this.parentId.compareTo(that.parentId);
            if (val != 0) {
                return val;
            }
            return 1;
        }
        if (this.rdns == null) {
            int res = this.parentId.compareTo(that.parentId);
            if (res == 0) {
                return -1;
            }
            return res;
        }
        int val = this.parentId.compareTo(that.getParentId());
        if (val != 0) {
            return val;
        }
        val = this.rdns.length - that.rdns.length;
        if (val != 0) {
            return val;
        }
        if (this.rdns.length == 1) {
            val = this.rdns[0].getNormName().compareTo(that.rdns[0].getNormName());
            return val;
        }
        for (int i = 0; i < this.rdns.length; ++i) {
            val = this.rdns[i].getNormName().compareTo(that.rdns[i].getNormName());
            if (val == 0) continue;
            return val;
        }
        return 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.parentId);
        out.writeInt(this.nbChildren);
        out.writeInt(this.nbDescendants);
        out.writeInt(this.rdns.length);
        for (Rdn rdn : this.rdns) {
            rdn.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.parentId = in.readUTF();
        this.nbChildren = in.readInt();
        this.nbDescendants = in.readInt();
        int size = in.readInt();
        this.rdns = new Rdn[size];
        for (int i = 0; i < size; ++i) {
            Rdn rdn = new Rdn();
            rdn.readExternal(in);
            this.rdns[i] = rdn;
        }
    }

    public int getNbChildren() {
        return this.nbChildren;
    }

    public void setNbChildren(int nbChildren) {
        this.nbChildren = nbChildren;
    }

    public int getNbDescendants() {
        return this.nbDescendants;
    }

    public void setNbDescendants(int nbDescendants) {
        this.nbDescendants = nbDescendants;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentIdAndRdn<");
        sb.append(this.parentId).append(", '");
        if (this.rdns == null) {
            sb.append("*'>");
        } else {
            boolean isFirst = true;
            for (Rdn rdn : this.rdns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(rdn);
            }
            sb.append("'>");
            sb.append("[nbC:").append(this.nbChildren).append(", nbD:").append(this.nbDescendants).append("]");
        }
        return sb.toString();
    }
}

