/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class XContentTypeOptionsFilter
implements Filter {
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String CUSTOM_HEADER_PARAM = "xcontent-type.options";
    public static final String DEFAULT_OPTION_VALUE = "nosniff";
    private String option = "nosniff";

    public void init(FilterConfig config) throws ServletException {
        String customOption = config.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customOption != null) {
            this.option = customOption;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)response).setHeader(X_CONTENT_TYPE_OPTIONS_HEADER, this.option);
        chain.doFilter(request, (ServletResponse)new XContentTypeOptionsResponseWrapper((HttpServletResponse)response));
    }

    public void destroy() {
    }

    class XContentTypeOptionsResponseWrapper
    extends HttpServletResponseWrapper {
        XContentTypeOptionsResponseWrapper(HttpServletResponse res) {
            super(res);
        }

        public void addHeader(String name, String value) {
            if (!name.equals(XContentTypeOptionsFilter.X_CONTENT_TYPE_OPTIONS_HEADER)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!name.equals(XContentTypeOptionsFilter.X_CONTENT_TYPE_OPTIONS_HEADER)) {
                super.setHeader(name, value);
            }
        }

        public String getHeader(String name) {
            String headerValue = null;
            headerValue = name.equals(XContentTypeOptionsFilter.X_CONTENT_TYPE_OPTIONS_HEADER) ? XContentTypeOptionsFilter.this.option : super.getHeader(name);
            return headerValue;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> names = (ArrayList<String>)super.getHeaderNames();
            if (names == null) {
                names = new ArrayList<String>();
            }
            names.add(XContentTypeOptionsFilter.X_CONTENT_TYPE_OPTIONS_HEADER);
            return names;
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> values = (ArrayList<String>)super.getHeaders(name);
            if (name.equals(XContentTypeOptionsFilter.X_CONTENT_TYPE_OPTIONS_HEADER)) {
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(XContentTypeOptionsFilter.this.option);
            }
            return values;
        }
    }
}

