/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.i18n.messages.MessageLoggerFactory;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.MessagesInvoker;
import org.apache.knox.gateway.i18n.messages.loggers.jdk.JdkMessageLoggerFactory;

public class MessagesFactory {
    private static MessageLoggerFactory loggers = MessagesFactory.getMessageLoggerFactory();
    private static Map<Class<?>, Object> proxies = new ConcurrentHashMap();

    public static <T> T get(Class<T> clazz) {
        Object proxy = proxies.get(clazz);
        if (proxy == null) {
            Messages anno = clazz.getAnnotation(Messages.class);
            if (anno == null) {
                throw new IllegalArgumentException(clazz.getName() + " missing @" + Messages.class.getCanonicalName());
            }
            MessagesInvoker invoker = new MessagesInvoker(clazz, loggers);
            proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)invoker);
            proxies.put(clazz, proxy);
        }
        return (T)proxy;
    }

    private static MessageLoggerFactory getMessageLoggerFactory() {
        ServiceLoader<MessageLoggerFactory> loader = ServiceLoader.load(MessageLoggerFactory.class);
        Iterator<MessageLoggerFactory> factories = loader.iterator();
        MessageLoggerFactory factory = factories != null && factories.hasNext() ? loader.iterator().next() : new JdkMessageLoggerFactory();
        return factory;
    }
}

