/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.util.function.Function;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;

public class ProfileManagerFactoryAware<C extends WebContext> {
    private final Function<C, ProfileManager> DEFAULT_PROFILE_MANAGER_FACTORY = ctx -> new ProfileManager((WebContext)ctx);
    private Function<C, ProfileManager> profileManagerFactory;

    protected ProfileManager getProfileManager(C context, Config config) {
        Function<WebContext, ProfileManager> configProfileManagerFactory = config.getProfileManagerFactory();
        if (configProfileManagerFactory != null) {
            return configProfileManagerFactory.apply((WebContext)context);
        }
        if (this.profileManagerFactory != null) {
            return this.profileManagerFactory.apply(context);
        }
        return this.DEFAULT_PROFILE_MANAGER_FACTORY.apply(context);
    }

    public Function<C, ProfileManager> getProfileManagerFactory() {
        return this.profileManagerFactory;
    }

    public void setProfileManagerFactory(Function<C, ProfileManager> factory) {
        CommonHelper.assertNotNull("factory", factory);
        this.profileManagerFactory = factory;
    }
}

