/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryClientServiceFactory;
import org.apache.knox.gateway.services.DefaultServerInfoService;
import org.apache.knox.gateway.services.GatewayMetricsServletContextListener;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.GatewayServicesContextListener;
import org.apache.knox.gateway.services.ServerInfoService;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.hostmap.impl.DefaultHostMapperService;
import org.apache.knox.gateway.services.metrics.impl.DefaultMetricsService;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceRegistryService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.SSLService;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;
import org.apache.knox.gateway.services.security.impl.DefaultCryptoService;
import org.apache.knox.gateway.services.security.impl.DefaultKeystoreService;
import org.apache.knox.gateway.services.security.impl.DefaultMasterService;
import org.apache.knox.gateway.services.security.impl.JettySSLService;
import org.apache.knox.gateway.services.security.impl.RemoteAliasService;
import org.apache.knox.gateway.services.token.impl.DefaultTokenAuthorityService;
import org.apache.knox.gateway.services.topology.impl.DefaultClusterConfigurationMonitorService;
import org.apache.knox.gateway.services.topology.impl.DefaultTopologyService;
import org.apache.knox.gateway.topology.Provider;

public class DefaultGatewayServices
implements GatewayServices {
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private Map<String, Service> services = new HashMap<String, Service>();
    private DefaultMasterService ms = null;
    private DefaultKeystoreService ks = null;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.ms = new DefaultMasterService();
        this.ms.init(config, options);
        this.services.put("MasterService", this.ms);
        this.ks = new DefaultKeystoreService();
        this.ks.setMasterService(this.ms);
        this.ks.init(config, options);
        this.services.put("KeystoreService", this.ks);
        RemoteAliasService alias = new RemoteAliasService();
        RemoteConfigurationRegistryClientService registryClientService = RemoteConfigurationRegistryClientServiceFactory.newInstance((GatewayConfig)config);
        registryClientService.setAliasService((AliasService)alias);
        registryClientService.init(config, options);
        this.services.put("RemoteConfigRegistryClientService", (Service)registryClientService);
        DefaultAliasService defaultAlias = new DefaultAliasService();
        defaultAlias.setKeystoreService(this.ks);
        defaultAlias.setMasterService(this.ms);
        defaultAlias.init(config, options);
        alias.setLocalAliasService(defaultAlias);
        alias.setMasterService(this.ms);
        alias.setRegistryClientService(registryClientService);
        alias.init(config, options);
        alias.start();
        this.services.put("AliasService", (Service)alias);
        DefaultCryptoService crypto = new DefaultCryptoService();
        crypto.setKeystoreService(this.ks);
        crypto.setAliasService(alias);
        crypto.init(config, options);
        this.services.put("CryptoService", (Service)crypto);
        DefaultTokenAuthorityService ts = new DefaultTokenAuthorityService();
        ts.setAliasService(alias);
        ts.setKeystoreService(this.ks);
        ts.init(config, options);
        this.services.put("TokenService", ts);
        JettySSLService ssl = new JettySSLService();
        ssl.setAliasService(alias);
        ssl.setKeystoreService(this.ks);
        ssl.setMasterService(this.ms);
        ssl.init(config, options);
        this.services.put("SSLService", (Service)ssl);
        DefaultServiceRegistryService sr = new DefaultServiceRegistryService();
        sr.setCryptoService(crypto);
        sr.init(config, options);
        this.services.put("ServiceRegistryService", sr);
        DefaultHostMapperService hm = new DefaultHostMapperService();
        hm.init(config, options);
        this.services.put("HostMappingService", (Service)hm);
        DefaultServerInfoService sis = new DefaultServerInfoService();
        sis.init(config, options);
        this.services.put("ServerInfoService", (Service)sis);
        DefaultClusterConfigurationMonitorService ccs = new DefaultClusterConfigurationMonitorService();
        ccs.setAliasService(alias);
        ccs.init(config, options);
        this.services.put("ClusterConfigurationMonitorService", (Service)ccs);
        DefaultTopologyService tops = new DefaultTopologyService();
        tops.setAliasService(alias);
        tops.init(config, options);
        this.services.put("TopologyService", (Service)tops);
        DefaultServiceDefinitionRegistry sdr = new DefaultServiceDefinitionRegistry();
        sdr.init(config, options);
        this.services.put("ServiceDefinitionRegistry", sdr);
        DefaultMetricsService metricsService = new DefaultMetricsService();
        metricsService.init(config, options);
        this.services.put("MetricsService", (Service)metricsService);
    }

    public void start() throws ServiceLifecycleException {
        this.ms.start();
        this.ks.start();
        Service alias = this.services.get("AliasService");
        alias.start();
        SSLService ssl = (SSLService)this.services.get("SSLService");
        ssl.start();
        ServerInfoService sis = (ServerInfoService)this.services.get("ServerInfoService");
        sis.start();
        RemoteConfigurationRegistryClientService clientService = (RemoteConfigurationRegistryClientService)this.services.get("RemoteConfigRegistryClientService");
        clientService.start();
        this.services.get("ClusterConfigurationMonitorService").start();
        DefaultTopologyService tops = (DefaultTopologyService)this.services.get("TopologyService");
        tops.start();
        DefaultMetricsService metricsService = (DefaultMetricsService)this.services.get("MetricsService");
        metricsService.start();
    }

    public void stop() throws ServiceLifecycleException {
        this.ms.stop();
        this.ks.stop();
        this.services.get("ClusterConfigurationMonitorService").stop();
        Service alias = this.services.get("AliasService");
        alias.stop();
        SSLService ssl = (SSLService)this.services.get("SSLService");
        ssl.stop();
        ServerInfoService sis = (ServerInfoService)this.services.get("ServerInfoService");
        sis.stop();
        DefaultTopologyService tops = (DefaultTopologyService)this.services.get("TopologyService");
        tops.stop();
        DefaultMetricsService metricsService = (DefaultMetricsService)this.services.get("MetricsService");
        metricsService.stop();
    }

    public Collection<String> getServiceNames() {
        return this.services.keySet();
    }

    public <T> T getService(String serviceName) {
        return (T)this.services.get(serviceName);
    }

    public String getRole() {
        return "Services";
    }

    public String getName() {
        return "GatewayServices";
    }

    public void initializeContribution(DeploymentContext context) {
        String clusterName = context.getTopology().getName();
        try {
            if (!this.ks.isCredentialStoreForClusterAvailable(clusterName)) {
                log.creatingCredentialStoreForCluster(clusterName);
                this.ks.createCredentialStoreForCluster(clusterName);
            } else {
                log.credentialStoreForClusterFoundNotCreating(clusterName);
            }
        }
        catch (KeystoreServiceException e) {
            throw new RuntimeException("Credential store was found but was unable to be loaded - the provided (or persisted) master secret may not match the password for the credential store.", e);
        }
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, org.apache.knox.gateway.topology.Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }

    public void finalizeContribution(DeploymentContext context) {
        context.getWebAppDescriptor().createListener().listenerClass(GatewayServicesContextListener.class.getName());
        context.getWebAppDescriptor().createListener().listenerClass(GatewayMetricsServletContextListener.class.getName());
    }
}

