/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;

class SimpleDescriptorImpl
implements SimpleDescriptor {
    @JsonProperty(value="discovery-type")
    private String discoveryType;
    @JsonProperty(value="discovery-address")
    private String discoveryAddress;
    @JsonProperty(value="discovery-user")
    private String discoveryUser;
    @JsonProperty(value="discovery-pwd-alias")
    private String discoveryPasswordAlias;
    @JsonProperty(value="provider-config-ref")
    private String providerConfig;
    @JsonProperty(value="cluster")
    private String cluster;
    @JsonProperty(value="services")
    private List<ServiceImpl> services;
    @JsonProperty(value="applications")
    private List<ApplicationImpl> applications;
    private String name = null;

    SimpleDescriptorImpl() {
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDiscoveryType() {
        return this.discoveryType;
    }

    @Override
    public String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    @Override
    public String getDiscoveryUser() {
        return this.discoveryUser;
    }

    @Override
    public String getDiscoveryPasswordAlias() {
        return this.discoveryPasswordAlias;
    }

    @Override
    public String getClusterName() {
        return this.cluster;
    }

    @Override
    public String getProviderConfig() {
        return this.providerConfig;
    }

    @Override
    public List<SimpleDescriptor.Service> getServices() {
        ArrayList<SimpleDescriptor.Service> result = new ArrayList<SimpleDescriptor.Service>();
        if (this.services != null) {
            result.addAll(this.services);
        }
        return result;
    }

    @Override
    public List<SimpleDescriptor.Application> getApplications() {
        ArrayList<SimpleDescriptor.Application> result = new ArrayList<SimpleDescriptor.Application>();
        if (this.applications != null) {
            result.addAll(this.applications);
        }
        return result;
    }

    public static class ApplicationImpl
    implements SimpleDescriptor.Application {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="params")
        private Map<String, String> params;
        @JsonProperty(value="urls")
        private List<String> urls;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getParams() {
            return this.params;
        }

        @Override
        public List<String> getURLs() {
            return this.urls;
        }
    }

    public static class ServiceImpl
    implements SimpleDescriptor.Service {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="params")
        private Map<String, String> params;
        @JsonProperty(value="urls")
        private List<String> urls;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public Map<String, String> getParams() {
            return this.params;
        }

        @Override
        public List<String> getURLs() {
            return this.urls;
        }
    }
}

