/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.html;

import java.util.Arrays;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFunctionProcessorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.html.HtmlPrefixDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;

public class HtmlPrefixProcessor
implements UrlRewriteFunctionProcessor<HtmlPrefixDescriptor> {
    private UrlRewriteFunctionProcessor frontend;

    @Override
    public void initialize(UrlRewriteEnvironment environment, HtmlPrefixDescriptor descriptor) throws Exception {
        Object frontendDescriptor = UrlRewriteFunctionDescriptorFactory.create("frontend");
        this.frontend = UrlRewriteFunctionProcessorFactory.create("frontend", frontendDescriptor);
        this.frontend.initialize(environment, frontendDescriptor);
    }

    @Override
    public String name() {
        return "prefix";
    }

    @Override
    public void destroy() throws Exception {
        this.frontend.destroy();
    }

    @Override
    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        String prefix = "";
        if (parameters != null && parameters.size() > 1) {
            prefix = parameters.get(0);
            parameters = parameters.subList(1, parameters.size());
        }
        List<String> frontendValues = this.frontend.resolve(context, parameters);
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        if (frontendValues != null && !frontendValues.isEmpty()) {
            for (String value : frontendValues) {
                buffer.append(value);
            }
        }
        return Arrays.asList(buffer.toString());
    }
}

