/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.config.remote.zk;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationMessages;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryConfig;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;

class RemoteConfigurationRegistryJAASConfig
extends Configuration {
    static final Map<String, String> digestLoginModules = new HashMap<String, String>();
    private static final RemoteConfigurationMessages log;
    private Configuration delegate = Configuration.getConfiguration();
    private AliasService aliasService;
    private Map<String, AppConfigurationEntry[]> contextEntries = new HashMap<String, AppConfigurationEntry[]>();

    static RemoteConfigurationRegistryJAASConfig configure(List<RemoteConfigurationRegistryConfig> configs, AliasService aliasService) {
        return new RemoteConfigurationRegistryJAASConfig(configs, aliasService);
    }

    private RemoteConfigurationRegistryJAASConfig(List<RemoteConfigurationRegistryConfig> configs, AliasService aliasService) {
        this.aliasService = aliasService;
        for (RemoteConfigurationRegistryConfig config : configs) {
            if (!config.isSecureRegistry()) continue;
            this.contextEntries.put(config.getName(), this.createEntries(config));
        }
        if (!this.contextEntries.isEmpty()) {
            Configuration.setConfiguration(this);
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] result = null;
        result = this.delegate.getAppConfigurationEntry(name);
        if (result == null || result.length < 1) {
            result = this.contextEntries.get(name);
        }
        return result;
    }

    private AppConfigurationEntry[] createEntries(RemoteConfigurationRegistryConfig config) {
        AppConfigurationEntry[] result = null;
        AppConfigurationEntry entry = this.createEntry(config);
        result = entry != null ? new AppConfigurationEntry[]{this.createEntry(config)} : new AppConfigurationEntry[]{};
        return result;
    }

    private AppConfigurationEntry createEntry(RemoteConfigurationRegistryConfig config) {
        AppConfigurationEntry entry = null;
        HashMap<String, String> opts = new HashMap<String, String>();
        SASLMechanism saslMechanism = RemoteConfigurationRegistryJAASConfig.getSASLMechanism(config.getAuthType());
        switch (saslMechanism) {
            case Digest: {
                opts.put("username", config.getPrincipal());
                char[] credential = null;
                if (this.aliasService != null) {
                    try {
                        credential = this.aliasService.getPasswordFromAliasForGateway(config.getCredentialAlias());
                    }
                    catch (AliasServiceException e) {
                        log.unresolvedCredentialAlias(config.getCredentialAlias());
                    }
                } else {
                    throw new IllegalArgumentException("The AliasService is required to resolve credential aliases.");
                }
                if (credential == null) break;
                opts.put("password", new String(credential));
                break;
            }
            case Kerberos: {
                opts.put("isUseTicketCache", String.valueOf(config.isUseTicketCache()));
                opts.put("isUseKeyTab", String.valueOf(config.isUseKeyTab()));
                opts.put("keyTab", config.getKeytab());
                opts.put("principal", config.getPrincipal());
            }
        }
        if (!opts.isEmpty()) {
            entry = new AppConfigurationEntry(RemoteConfigurationRegistryJAASConfig.getLoginModuleName(config.getRegistryType(), saslMechanism), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, opts);
        }
        return entry;
    }

    private static String getLoginModuleName(String registryType, SASLMechanism saslMechanism) {
        String loginModuleName = null;
        switch (saslMechanism) {
            case Kerberos: {
                if (System.getProperty("java.vendor").contains("IBM")) {
                    loginModuleName = "com.ibm.security.auth.module.Krb5LoginModule";
                    break;
                }
                loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
                break;
            }
            case Digest: {
                loginModuleName = digestLoginModules.get(registryType.toUpperCase(Locale.ROOT));
            }
        }
        return loginModuleName;
    }

    private static SASLMechanism getSASLMechanism(String authType) {
        SASLMechanism result = SASLMechanism.Unsupported;
        for (SASLMechanism at : SASLMechanism.values()) {
            if (!at.name().equalsIgnoreCase(authType)) continue;
            result = at;
            break;
        }
        return result;
    }

    static {
        digestLoginModules.put("ZOOKEEPER", "org.apache.zookeeper.server.auth.DigestLoginModule");
        log = (RemoteConfigurationMessages)MessagesFactory.get(RemoteConfigurationMessages.class);
    }

    static enum SASLMechanism {
        Unsupported,
        Kerberos,
        Digest;

    }
}

