/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.jdbc.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.shell.jdbc.Database;
import org.apache.knox.gateway.shell.jdbc.derby.DerbyDatabaseException;

public class DerbyDatabase
implements Database {
    public static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String PROTOCOL = "jdbc:derby:";
    private static final String CREATE_ATTRIBUTE = ";create=true";
    private static final String SHUTDOWN_ATTRIBUTE = ";shutdown=true";
    private final String dbUri;

    public DerbyDatabase(String directory) throws DerbyDatabaseException {
        this.dbUri = PROTOCOL + directory;
        this.loadDriver();
    }

    @Override
    public void create() throws SQLException {
        try (Connection conn = null;){
            conn = DriverManager.getConnection(this.dbUri + CREATE_ATTRIBUTE);
        }
    }

    @Override
    public void shutdown() {
        try {
            DriverManager.getConnection(this.dbUri + SHUTDOWN_ATTRIBUTE);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 45000 && "08006".equals(e.getSQLState())) {
                this.log(MessageLevel.INFO, "Derby database is closed");
            }
            this.log(MessageLevel.WARN, "Derby database closed abnormally", e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.dbUri);
    }

    @Override
    public boolean hasTable(String tableName) throws SQLException {
        return this.hasTable(null, tableName);
    }

    @Override
    public boolean hasTable(String schemaName, String tableName) throws SQLException {
        boolean result = false;
        try (Connection connection = this.getConnection();
             ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableName, null);){
            result = tables.next();
        }
        catch (SQLException e) {
            this.log(MessageLevel.ERROR, "SQL error occured while checking table " + tableName + " in the database", e);
        }
        return result;
    }

    private void loadDriver() throws DerbyDatabaseException {
        try {
            Class.forName(DRIVER).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DerbyDatabaseException("Unable to load the JDBC driver org.apache.derby.jdbc.EmbeddedDriver. Check your CLASSPATH.", e);
        }
        catch (InstantiationException e) {
            throw new DerbyDatabaseException("Unable to instantiate the JDBC driver org.apache.derby.jdbc.EmbeddedDriver", e);
        }
        catch (IllegalAccessException e) {
            throw new DerbyDatabaseException("Not allowed to access the JDBC driver org.apache.derby.jdbc.EmbeddedDriver", e);
        }
    }

    private void log(MessageLevel logLevel, String message) {
        this.log(logLevel, message, null);
    }

    private void log(MessageLevel logLevel, String message, Throwable error) {
        System.out.println(logLevel.name() + " - " + message + (error == null ? "" : " - caused by " + error));
    }
}

