/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.trace.TraceRequest;
import org.apache.knox.gateway.trace.TraceResponse;
import org.apache.knox.gateway.trace.TraceUtil;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class TraceHandler
extends HandlerWrapper {
    static final String HTTP_LOGGER = "org.apache.knox.gateway.http";
    static final String HTTP_REQUEST_LOGGER = "org.apache.knox.gateway.http.request";
    static final String HTTP_REQUEST_HEADER_LOGGER = "org.apache.knox.gateway.http.request.headers";
    static final String HTTP_REQUEST_BODY_LOGGER = "org.apache.knox.gateway.http.request.body";
    static final String HTTP_RESPONSE_LOGGER = "org.apache.knox.gateway.http.response";
    static final String HTTP_RESPONSE_HEADER_LOGGER = "org.apache.knox.gateway.http.response.headers";
    static final String HTTP_RESPONSE_BODY_LOGGER = "org.apache.knox.gateway.http.response.body";
    private Set<Integer> bodyFilter;

    public void setTracedBodyFilter(String s) {
        this.bodyFilter = TraceUtil.parseIntegerSet(s);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        TraceRequest newRequest = new TraceRequest(request);
        TraceResponse newResponse = new TraceResponse(response, this.bodyFilter);
        super.handle(target, baseRequest, (HttpServletRequest)newRequest, (HttpServletResponse)newResponse);
    }
}

