/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.util;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.FindBest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class Pac4jProducer {
    private static final Logger logger = LoggerFactory.getLogger(Pac4jProducer.class);

    @Produces
    JEEContext getWebContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        logger.trace("Producing a pac4j web context...");
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)Config.INSTANCE, (SessionStore)JEESessionStore.INSTANCE);
        JEEContext jEEContext = new JEEContext(httpServletRequest, httpServletResponse, bestSessionStore);
        logger.trace("Returning a pac4j web context.");
        return jEEContext;
    }

    @Produces
    ProfileManager getProfileManager(WebContext webContext) {
        logger.trace("Producing a pac4j profile manager...");
        ProfileManager profileManager = new ProfileManager(webContext);
        logger.trace("Returning a pac4j profile manager.");
        return profileManager;
    }
}

