/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiTimeSeriesCrossEntityMetadata;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Statistics related to one time series aggregate data point. It is available from v6 for data points containing aggregate data. It includes further statistics about the data point. An aggregate can be across entities (e.g., fd_open_across_datanodes), over time (e.g., a daily point for the fd_open metric for a specific DataNode), or both (e.g., a daily point for the fd_open_across_datanodes metric). If the data point is for non-aggregate date this will return null.")
public class ApiTimeSeriesAggregateStatistics {
    @SerializedName(value="sampleTime")
    private String sampleTime = null;
    @SerializedName(value="sampleValue")
    private BigDecimal sampleValue = null;
    @SerializedName(value="count")
    private BigDecimal count = null;
    @SerializedName(value="min")
    private BigDecimal min = null;
    @SerializedName(value="minTime")
    private String minTime = null;
    @SerializedName(value="max")
    private BigDecimal max = null;
    @SerializedName(value="maxTime")
    private String maxTime = null;
    @SerializedName(value="mean")
    private BigDecimal mean = null;
    @SerializedName(value="stdDev")
    private BigDecimal stdDev = null;
    @SerializedName(value="crossEntityMetadata")
    private ApiTimeSeriesCrossEntityMetadata crossEntityMetadata = null;

    public ApiTimeSeriesAggregateStatistics sampleTime(String sampleTime) {
        this.sampleTime = sampleTime;
        return this;
    }

    @ApiModelProperty(value="The timestamp of the sample data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.")
    public String getSampleTime() {
        return this.sampleTime;
    }

    public void setSampleTime(String sampleTime) {
        this.sampleTime = sampleTime;
    }

    public ApiTimeSeriesAggregateStatistics sampleValue(BigDecimal sampleValue) {
        this.sampleValue = sampleValue;
        return this;
    }

    @ApiModelProperty(value="The sample data point value representing an actual sample value picked from the underlying data that is being aggregated.")
    public BigDecimal getSampleValue() {
        return this.sampleValue;
    }

    public void setSampleValue(BigDecimal sampleValue) {
        this.sampleValue = sampleValue;
    }

    public ApiTimeSeriesAggregateStatistics count(BigDecimal count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="The number of individual data points aggregated in this data point.")
    public BigDecimal getCount() {
        return this.count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public ApiTimeSeriesAggregateStatistics min(BigDecimal min) {
        this.min = min;
        return this;
    }

    @ApiModelProperty(value="This minimum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the minimum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the minimum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the minimum value for any entity across the aggregation period.")
    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public ApiTimeSeriesAggregateStatistics minTime(String minTime) {
        this.minTime = minTime;
        return this;
    }

    @ApiModelProperty(value="The timestamp of the minimum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.")
    public String getMinTime() {
        return this.minTime;
    }

    public void setMinTime(String minTime) {
        this.minTime = minTime;
    }

    public ApiTimeSeriesAggregateStatistics max(BigDecimal max) {
        this.max = max;
        return this;
    }

    @ApiModelProperty(value="This maximum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the maximum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the maximum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the maximum value for any entity across the aggregation period.")
    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public ApiTimeSeriesAggregateStatistics maxTime(String maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @ApiModelProperty(value="The timestamp of the maximum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.")
    public String getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(String maxTime) {
        this.maxTime = maxTime;
    }

    public ApiTimeSeriesAggregateStatistics mean(BigDecimal mean) {
        this.mean = mean;
        return this;
    }

    @ApiModelProperty(value="The mean of the values of all data-points for this aggregate data point.")
    public BigDecimal getMean() {
        return this.mean;
    }

    public void setMean(BigDecimal mean) {
        this.mean = mean;
    }

    public ApiTimeSeriesAggregateStatistics stdDev(BigDecimal stdDev) {
        this.stdDev = stdDev;
        return this;
    }

    @ApiModelProperty(value="The standard deviation of the values of all data-points for this aggregate data point.")
    public BigDecimal getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(BigDecimal stdDev) {
        this.stdDev = stdDev;
    }

    public ApiTimeSeriesAggregateStatistics crossEntityMetadata(ApiTimeSeriesCrossEntityMetadata crossEntityMetadata) {
        this.crossEntityMetadata = crossEntityMetadata;
        return this;
    }

    @ApiModelProperty(value="If the data-point is for a cross entity aggregate (e.g., fd_open_across_datanodes) returns the cross entity metadata, null otherwise.")
    public ApiTimeSeriesCrossEntityMetadata getCrossEntityMetadata() {
        return this.crossEntityMetadata;
    }

    public void setCrossEntityMetadata(ApiTimeSeriesCrossEntityMetadata crossEntityMetadata) {
        this.crossEntityMetadata = crossEntityMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesAggregateStatistics apiTimeSeriesAggregateStatistics = (ApiTimeSeriesAggregateStatistics)o;
        return Objects.equals(this.sampleTime, apiTimeSeriesAggregateStatistics.sampleTime) && Objects.equals(this.sampleValue, apiTimeSeriesAggregateStatistics.sampleValue) && Objects.equals(this.count, apiTimeSeriesAggregateStatistics.count) && Objects.equals(this.min, apiTimeSeriesAggregateStatistics.min) && Objects.equals(this.minTime, apiTimeSeriesAggregateStatistics.minTime) && Objects.equals(this.max, apiTimeSeriesAggregateStatistics.max) && Objects.equals(this.maxTime, apiTimeSeriesAggregateStatistics.maxTime) && Objects.equals(this.mean, apiTimeSeriesAggregateStatistics.mean) && Objects.equals(this.stdDev, apiTimeSeriesAggregateStatistics.stdDev) && Objects.equals(this.crossEntityMetadata, apiTimeSeriesAggregateStatistics.crossEntityMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.sampleTime, this.sampleValue, this.count, this.min, this.minTime, this.max, this.maxTime, this.mean, this.stdDev, this.crossEntityMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesAggregateStatistics {\n");
        sb.append("    sampleTime: ").append(this.toIndentedString(this.sampleTime)).append("\n");
        sb.append("    sampleValue: ").append(this.toIndentedString(this.sampleValue)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    minTime: ").append(this.toIndentedString(this.minTime)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    maxTime: ").append(this.toIndentedString(this.maxTime)).append("\n");
        sb.append("    mean: ").append(this.toIndentedString(this.mean)).append("\n");
        sb.append("    stdDev: ").append(this.toIndentedString(this.stdDev)).append("\n");
        sb.append("    crossEntityMetadata: ").append(this.toIndentedString(this.crossEntityMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

