/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.hadoopauth.HadoopAuthMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.filter.JWTFederationFilter;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.util.AuthFilterUtils;

public class HadoopAuthFilter
extends AuthenticationFilter {
    private static final String QUERY_PARAMETER_DOAS = "doAs";
    private static final String PROXYUSER_PREFIX = "hadoop.proxyuser";
    static final String SUPPORT_JWT = "support.jwt";
    private static final HadoopAuthMessages LOG = (HadoopAuthMessages)MessagesFactory.get(HadoopAuthMessages.class);
    private static final String HADOOP_AUTH_UNAUTHENTICATED_PATHS_PARAM = "hadoop.auth.unauthenticated.path.list";
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private final Set<String> ignoreDoAs = new HashSet<String>();
    private JWTFederationFilter jwtFilter;
    private Set<String> unAuthenticatedPaths = new HashSet<String>(20);

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        GatewayServices services = GatewayServer.getGatewayServices();
        AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        return this.getConfiguration(aliasService, configPrefix, filterConfig);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Object attributeValue;
        Configuration conf = this.getProxyuserConfiguration(filterConfig);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf, (String)PROXYUSER_PREFIX);
        Collection<String> ignoredServices = null;
        String configValue = filterConfig.getInitParameter("gateway.proxyuser.services.ignore.doas");
        if (configValue != null && !(configValue = configValue.trim()).isEmpty()) {
            ignoredServices = Arrays.asList(configValue.toLowerCase(Locale.ROOT).split("\\s*,\\s*"));
        }
        if (ignoredServices == null && (attributeValue = filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config")) instanceof GatewayConfig) {
            ignoredServices = ((GatewayConfig)attributeValue).getServicesToIgnoreDoAs();
        }
        if (ignoredServices != null) {
            this.ignoreDoAs.addAll(ignoredServices);
        }
        super.init(filterConfig);
        String supportJwt = filterConfig.getInitParameter(SUPPORT_JWT);
        boolean jwtSupported = Boolean.parseBoolean(supportJwt == null ? "false" : supportJwt);
        if (jwtSupported) {
            this.jwtFilter = new JWTFederationFilter();
            this.jwtFilter.init(filterConfig);
            LOG.initializedJwtFilter();
        }
        String unAuthPathString = filterConfig.getInitParameter(HADOOP_AUTH_UNAUTHENTICATED_PATHS_PARAM);
        AuthFilterUtils.addUnauthPaths(this.unAuthenticatedPaths, (String)unAuthPathString, (String)"/knoxtoken/api/v1/jwks.json");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (AuthFilterUtils.doesRequestContainUnauthPath(this.unAuthenticatedPaths, (ServletRequest)request)) {
            this.continueWithAnonymousSubject(request, response, filterChain);
            return;
        }
        if (HadoopAuthFilter.shouldUseJwtFilter(this.jwtFilter, (HttpServletRequest)request)) {
            LOG.useJwtFilter();
            this.jwtFilter.doFilter(request, response, filterChain);
        } else {
            super.doFilter(request, response, filterChain);
        }
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String doAsUser;
        if (AuthFilterUtils.doesRequestContainUnauthPath(this.unAuthenticatedPaths, (ServletRequest)request)) {
            this.continueWithAnonymousSubject((ServletRequest)request, (ServletResponse)response, filterChain);
            return;
        }
        if (HadoopAuthFilter.shouldUseJwtFilter(this.jwtFilter, request)) {
            LOG.useJwtFilter();
            this.jwtFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            return;
        }
        if (!this.ignoreDoAs(request.getRemoteUser()) && (doAsUser = request.getParameter(QUERY_PARAMETER_DOAS)) != null && !doAsUser.equals(request.getRemoteUser())) {
            UserGroupInformation requestUgi;
            LOG.hadoopAuthDoAsUser(doAsUser, request.getRemoteUser(), request.getRemoteAddr());
            UserGroupInformation userGroupInformation = requestUgi = request.getUserPrincipal() != null ? UserGroupInformation.createRemoteUser((String)request.getRemoteUser()) : null;
            if (requestUgi != null) {
                requestUgi = UserGroupInformation.createProxyUser((String)doAsUser, (UserGroupInformation)requestUgi);
                try {
                    ProxyUsers.authorize((UserGroupInformation)requestUgi, (String)request.getRemoteAddr());
                    final UserGroupInformation ugiF = requestUgi;
                    request = new HttpServletRequestWrapper((HttpServletRequest)request){

                        public String getRemoteUser() {
                            return ugiF.getShortUserName();
                        }

                        public Principal getUserPrincipal() {
                            return () -> ((UserGroupInformation)ugiF).getUserName();
                        }
                    };
                    LOG.hadoopAuthProxyUserSuccess();
                }
                catch (AuthorizationException ex) {
                    HttpExceptionUtils.createServletExceptionResponse((HttpServletResponse)response, (int)403, (Throwable)ex);
                    LOG.hadoopAuthProxyUserFailed(ex);
                    return;
                }
            }
        }
        super.doFilter(filterChain, request, response);
    }

    private void continueWithAnonymousSubject(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            Subject sub = new Subject();
            sub.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
            LOG.unauthenticatedPathBypass(((HttpServletRequest)request).getRequestURI(), this.unAuthenticatedPaths.toString());
            this.continueWithEstablishedSecurityContext(sub, (HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        catch (Exception e) {
            LOG.unauthenticatedPathError(((HttpServletRequest)request).getRequestURI(), e.toString());
            throw e;
        }
    }

    protected void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        final Principal principal = (Principal)subject.getPrincipals(PrimaryPrincipal.class).toArray()[0];
        AuditContext context = auditService.getContext();
        if (context != null) {
            context.setUsername(principal.getName());
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            if (sourceUri != null) {
                auditor.audit("authentication", sourceUri, "uri", "success");
            }
        }
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)new AnonymousRequest(request, principal), (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    static boolean shouldUseJwtFilter(JWTFederationFilter jwtFilter, HttpServletRequest request) throws IOException, ServletException {
        return jwtFilter == null ? false : jwtFilter.getWireToken((ServletRequest)request) != null;
    }

    boolean ignoreDoAs(String userName) {
        return userName == null || userName.isEmpty() || this.ignoreDoAs.contains(userName.toLowerCase(Locale.ROOT));
    }

    private Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Configuration conf = new Configuration(false);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("hadoop.proxyuser.")) continue;
            String value = filterConfig.getInitParameter(name);
            conf.set(name, value);
        }
        return conf;
    }

    Properties getConfiguration(AliasService aliasService, String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = this.handleAlias(aliasService, filterConfig, filterConfig.getInitParameter(name), name);
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    private String handleAlias(AliasService aliasService, FilterConfig filterConfig, String value, String name) throws ServletException {
        String result = value;
        if (value.startsWith("${ALIAS=") && value.endsWith("}")) {
            try {
                String clusterName = filterConfig.getInitParameter("clusterName");
                String alias = value.substring("${ALIAS=".length(), value.length() - 1);
                char[] topologyLevelAliasValue = aliasService.getPasswordFromAliasForCluster(clusterName, alias);
                if (topologyLevelAliasValue == null) {
                    char[] gatewayLevelAliasValue = aliasService.getPasswordFromAliasForGateway(alias);
                    if (gatewayLevelAliasValue != null) {
                        result = String.valueOf(gatewayLevelAliasValue);
                    } else {
                        LOG.noAliasStored(clusterName, alias);
                    }
                } else {
                    result = String.valueOf(topologyLevelAliasValue);
                }
            }
            catch (AliasServiceException e) {
                throw new ServletException("Unable to retrieve alias for config: " + name, (Throwable)e);
            }
        }
        return result;
    }

    boolean isJwtSupported() {
        return this.jwtFilter != null;
    }

    private class AnonymousRequest
    extends HttpServletRequestWrapper {
        private Principal principal;

        AnonymousRequest(HttpServletRequest req, Principal principal) {
            super(req);
            this.principal = principal;
        }

        public String getRemoteUser() {
            return this.principal.getName();
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }
    }
}

