/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;

public class JdbmPartitionFactory
implements PartitionFactory {
    public JdbmPartition createPartition(SchemaManager schemaManager, DnFactory dnFactory, String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        JdbmPartition partition = new JdbmPartition(schemaManager, dnFactory);
        partition.setId(id);
        partition.setSuffixDn(new Dn(schemaManager, new String[]{suffix}));
        partition.setCacheSize(cacheSize);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    @Override
    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof JdbmPartition)) {
            throw new IllegalArgumentException("Partition must be a JdbmPartition");
        }
        JdbmPartition jdbmPartition = (JdbmPartition)partition;
        Set indexedAttributes = jdbmPartition.getIndexedAttributes();
        JdbmIndex index = new JdbmIndex(attributeId, false);
        index.setCacheSize(cacheSize);
        indexedAttributes.add(index);
        jdbmPartition.setIndexedAttributes(indexedAttributes);
    }
}

