/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorRedirectFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ErrorHolder> errors = new ArrayList<ErrorHolder>();
    private String defaultErrorRedirectPage;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            filterChain.doFilter(request, response);
        }
        catch (Exception e) {
            Throwable t = this.extractErrorToCompare(e);
            ErrorHolder currentMatch = null;
            for (ErrorHolder errorHolder : this.errors) {
                if (errorHolder.exactMatch(t)) {
                    currentMatch = errorHolder;
                    break;
                }
                if (!errorHolder.inheritanceMatch(t)) continue;
                currentMatch = errorHolder;
            }
            if (currentMatch != null) {
                httpResponse.sendRedirect(currentMatch.getUrl());
            }
            httpResponse.sendRedirect(this.defaultErrorRedirectPage);
        }
    }

    private Throwable extractErrorToCompare(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            return cause;
        }
        return throwable;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.defaultErrorRedirectPage = filterConfig.getInitParameter("defaultErrorRedirectPage");
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String className = (String)enumeration.nextElement();
            try {
                if (className.equals("defaultErrorRedirectPage")) continue;
                this.errors.add(new ErrorHolder(className, filterConfig.getInitParameter(className)));
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("Class [{}] cannot be found in ClassLoader.  Ignoring.", (Object)className);
            }
        }
    }

    protected final class ErrorHolder {
        private Class<?> className;
        private String url;

        protected ErrorHolder(String className, String url) throws ClassNotFoundException {
            this.className = Class.forName(className);
            this.url = url;
        }

        public boolean exactMatch(Throwable e) {
            return this.className.equals(e.getClass());
        }

        public boolean inheritanceMatch(Throwable e) {
            return this.className.isAssignableFrom(e.getClass());
        }

        public String getUrl() {
            return this.url;
        }
    }
}

