/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.ClustersResourceApi;
import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiCluster;
import com.cloudera.api.swagger.model.ApiClusterList;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.cloudera.api.swagger.model.ApiServiceList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerCluster;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClouderaManagerClusterConfigurationMonitor;

public class ClouderaManagerServiceDiscovery
implements ServiceDiscovery {
    static final String TYPE = "ClouderaManager";
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    static final String API_PATH = "api/v32";
    private static final String CLUSTER_TYPE_ANY = "any";
    private static final String VIEW_SUMMARY = "summary";
    private static final String VIEW_FULL = "full";
    static final String DEFAULT_USER_ALIAS = "cm.discovery.user";
    static final String DEFAULT_PWD_ALIAS = "cm.discovery.password";
    public static final String CM_SERVICE_TYPE = "CM";
    public static final String CM_ROLE_TYPE = "CM_SERVER";
    private static Map<String, List<ServiceModelGenerator>> serviceModelGenerators = new HashMap<String, List<ServiceModelGenerator>>();
    private boolean debug;
    private AliasService aliasService;
    private KeystoreService keystoreService;
    private ClouderaManagerClusterConfigurationMonitor configChangeMonitor;

    ClouderaManagerServiceDiscovery() {
        this(false);
    }

    ClouderaManagerServiceDiscovery(boolean debug) {
        GatewayServices gwServices = GatewayServer.getGatewayServices();
        if (gwServices != null) {
            this.aliasService = (AliasService)gwServices.getService(ServiceType.ALIAS_SERVICE);
            this.keystoreService = (KeystoreService)gwServices.getService(ServiceType.KEYSTORE_SERVICE);
        }
        this.debug = debug;
        this.configChangeMonitor = this.getConfigurationChangeMonitor();
    }

    public String getType() {
        return TYPE;
    }

    private DiscoveryApiClient getClient(ServiceDiscoveryConfig discoveryConfig) {
        String discoveryAddress = discoveryConfig.getAddress();
        if (discoveryAddress == null || discoveryAddress.isEmpty()) {
            log.missingDiscoveryAddress();
            throw new IllegalArgumentException("Missing or invalid discovery address.");
        }
        DiscoveryApiClient client = new DiscoveryApiClient(discoveryConfig, this.aliasService, this.keystoreService);
        client.setDebugging(this.debug);
        return client;
    }

    private ClouderaManagerClusterConfigurationMonitor getConfigurationChangeMonitor() {
        ClouderaManagerClusterConfigurationMonitor cmMonitor = null;
        try {
            ClusterConfigurationMonitorService clusterMonitorService;
            ClusterConfigurationMonitor monitor;
            GatewayServices gwServices = GatewayServer.getGatewayServices();
            if (gwServices != null && (monitor = (clusterMonitorService = (ClusterConfigurationMonitorService)GatewayServer.getGatewayServices().getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE)).getMonitor(ClouderaManagerClusterConfigurationMonitor.getType())) != null && ClouderaManagerClusterConfigurationMonitor.class.isAssignableFrom(monitor.getClass())) {
                cmMonitor = (ClouderaManagerClusterConfigurationMonitor)monitor;
            }
        }
        catch (Exception e) {
            log.errorAccessingConfigurationChangeMonitor(e);
        }
        return cmMonitor;
    }

    public Map<String, ServiceDiscovery.Cluster> discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig) {
        HashMap<String, ServiceDiscovery.Cluster> clusters = new HashMap<String, ServiceDiscovery.Cluster>();
        DiscoveryApiClient client = this.getClient(discoveryConfig);
        List<ApiCluster> apiClusters = ClouderaManagerServiceDiscovery.getClusters(client);
        for (ApiCluster apiCluster : apiClusters) {
            String clusterName = apiCluster.getName();
            log.discoveredCluster(clusterName, apiCluster.getFullVersion());
            ClouderaManagerCluster cluster = this.discover(gatewayConfig, discoveryConfig, clusterName, client);
            clusters.put(clusterName, cluster);
        }
        return clusters;
    }

    public ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, this.getClient(discoveryConfig));
    }

    protected ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, DiscoveryApiClient client) {
        ClouderaManagerCluster cluster = null;
        if (clusterName == null || clusterName.isEmpty()) {
            log.missingDiscoveryCluster();
            throw new IllegalArgumentException("The cluster configuration is missing from, or invalid in, the discovery configuration.");
        }
        try {
            cluster = ClouderaManagerServiceDiscovery.discoverCluster(client, clusterName);
            if (this.configChangeMonitor != null) {
                this.configChangeMonitor.addServiceConfiguration(cluster, discoveryConfig);
            }
        }
        catch (ApiException e) {
            log.clusterDiscoveryError(clusterName, (Exception)((Object)e));
        }
        return cluster;
    }

    private static List<ApiCluster> getClusters(DiscoveryApiClient client) {
        ArrayList<ApiCluster> clusters = new ArrayList<ApiCluster>();
        try {
            ClustersResourceApi clustersResourceApi = new ClustersResourceApi((ApiClient)client);
            ApiClusterList clusterList = clustersResourceApi.readClusters(CLUSTER_TYPE_ANY, VIEW_SUMMARY);
            if (clusterList != null) {
                clusters.addAll(clusterList.getItems());
            }
        }
        catch (Exception e) {
            log.clusterDiscoveryError(CLUSTER_TYPE_ANY, e);
        }
        return clusters;
    }

    private static ClouderaManagerCluster discoverCluster(DiscoveryApiClient client, String clusterName) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi((ApiClient)client);
        RolesResourceApi rolesResourceApi = new RolesResourceApi((ApiClient)client);
        log.discoveringCluster(clusterName);
        ClouderaManagerCluster cluster = new ClouderaManagerCluster(clusterName);
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        ApiServiceList serviceList = ClouderaManagerServiceDiscovery.getClusterServices(servicesResourceApi, clusterName);
        if (serviceList != null) {
            ApiService cmService = new ApiService();
            cmService.setName(CM_SERVICE_TYPE.toLowerCase(Locale.ROOT));
            cmService.setType(CM_SERVICE_TYPE);
            serviceList.addItemsItem(cmService);
            for (ApiService service : serviceList.getItems()) {
                ApiRoleList roleList;
                String serviceName = service.getName();
                log.discoveredService(serviceName, service.getType());
                ApiServiceConfig serviceConfig = null;
                if (!CM_SERVICE_TYPE.equals(service.getType())) {
                    serviceConfig = ClouderaManagerServiceDiscovery.getServiceConfig(servicesResourceApi, clusterName, serviceName);
                }
                if ((roleList = ClouderaManagerServiceDiscovery.getRoles(rolesResourceApi, clusterName, serviceName)) == null) continue;
                for (ApiRole role : roleList.getItems()) {
                    List<ServiceModelGenerator> smgList;
                    String roleName = role.getName();
                    log.discoveredServiceRole(roleName, role.getType());
                    ApiConfigList roleConfig = null;
                    if (!CM_SERVICE_TYPE.equals(service.getType())) {
                        roleConfig = ClouderaManagerServiceDiscovery.getRoleConfig(rolesResourceApi, clusterName, serviceName, roleName);
                    }
                    if ((smgList = serviceModelGenerators.get(service.getType())) == null) continue;
                    for (ServiceModelGenerator serviceModelGenerator : smgList) {
                        ServiceModelGeneratorHandleResponse response = serviceModelGenerator.handles(service, serviceConfig, role, roleConfig);
                        if (response.handled()) {
                            serviceModelGenerator.setApiClient(client);
                            ServiceModel serviceModel = serviceModelGenerator.generateService(service, serviceConfig, role, roleConfig);
                            serviceModels.add(serviceModel);
                            continue;
                        }
                        if (response.getConfigurationIssues().isEmpty()) continue;
                        log.serviceRoleHasConfigurationIssues(roleName, String.join((CharSequence)";", response.getConfigurationIssues()));
                    }
                }
            }
        }
        cluster.addServiceModels(serviceModels);
        return cluster;
    }

    private static ApiServiceList getClusterServices(ServicesResourceApi servicesResourceApi, String clusterName) {
        ApiServiceList services = null;
        try {
            services = servicesResourceApi.readServices(clusterName, VIEW_SUMMARY);
        }
        catch (ApiException e) {
            log.failedToAccessServiceConfigs(clusterName, (Exception)((Object)e));
        }
        return services;
    }

    private static ApiServiceConfig getServiceConfig(ServicesResourceApi servicesResourceApi, String clusterName, String serviceName) {
        ApiServiceConfig serviceConfig = null;
        try {
            serviceConfig = servicesResourceApi.readServiceConfig(clusterName, serviceName, VIEW_FULL);
        }
        catch (Exception e) {
            log.failedToAccessServiceConfigs(clusterName, e);
        }
        return serviceConfig;
    }

    private static ApiRoleList getRoles(RolesResourceApi rolesResourceApi, String clusterName, String serviceName) {
        ApiRoleList roles = null;
        try {
            if (CM_SERVICE_TYPE.equalsIgnoreCase(serviceName)) {
                roles = new ApiRoleList();
                ApiRole cmRole = new ApiRole();
                cmRole.setName(CM_ROLE_TYPE);
                cmRole.setType(CM_ROLE_TYPE);
                roles.addItemsItem(cmRole);
                return roles;
            }
            roles = rolesResourceApi.readRoles(clusterName, serviceName, "", VIEW_SUMMARY);
        }
        catch (Exception e) {
            log.failedToAccessServiceRoleConfigs(clusterName, e);
        }
        return roles;
    }

    private static ApiConfigList getRoleConfig(RolesResourceApi rolesResourceApi, String clusterName, String serviceName, String roleName) {
        ApiConfigList configList = null;
        try {
            configList = rolesResourceApi.readRoleConfig(clusterName, roleName, serviceName, VIEW_FULL);
        }
        catch (Exception e) {
            log.failedToAccessServiceRoleConfigs(clusterName, e);
        }
        return configList;
    }

    static {
        ServiceLoader<ServiceModelGenerator> loader = ServiceLoader.load(ServiceModelGenerator.class);
        for (ServiceModelGenerator serviceModelGenerator : loader) {
            List smgList = serviceModelGenerators.computeIfAbsent(serviceModelGenerator.getServiceType(), k -> new ArrayList());
            smgList.add(serviceModelGenerator);
        }
    }
}

