/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdbm.RecordManager;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TransactionManager;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseRecordManager
implements RecordManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)BaseRecordManager.class.getSimpleName());
    private RecordFile recordFile;
    private PhysicalRowIdManager physMgr;
    private LogicalRowIdManager logMgr;
    private PageManager pageMgr;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final boolean DEBUG = false;
    private Map<String, Long> nameDirectory;
    private final ConcurrentHashMap<Long, LockElement> lockElements;

    public BaseRecordManager(String filename) throws IOException {
        this.recordFile = new RecordFile(filename);
        this.pageMgr = new PageManager(this.recordFile);
        this.physMgr = new PhysicalRowIdManager(this.pageMgr);
        this.logMgr = new LogicalRowIdManager(this.pageMgr);
        this.lockElements = new ConcurrentHashMap();
    }

    public TransactionManager getTransactionManager() throws IOException {
        this.checkIfClosed();
        return this.recordFile.getTxnMgr();
    }

    public void disableTransactions() {
        this.checkIfClosed();
        this.recordFile.disableTransactions();
    }

    @Override
    public void close() throws IOException {
        this.checkIfClosed();
        this.pageMgr.close();
        this.pageMgr = null;
        this.recordFile.close();
        this.recordFile = null;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        byte[] data = serializer.serialize(obj);
        Location physRowId = this.physMgr.insert(data, 0, data.length);
        long recid = this.logMgr.insert(physRowId).toLong();
        LOG.debug("BaseRecordManager.insert() recid {} length {}", (Object)recid, (Object)data.length);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long recid) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        LOG.debug("BaseRecordManager.delete() recid {}", (Object)recid);
        LockElement element = this.beginIO(recid, IOType.WRITE_IO);
        try {
            Location logRowId = new Location(recid);
            Location physRowId = this.logMgr.fetch(logRowId);
            this.physMgr.delete(physRowId);
            this.logMgr.delete(logRowId);
        }
        finally {
            this.endIO(recid, element, IOType.WRITE_IO);
        }
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        LockElement element = this.beginIO(recid, IOType.WRITE_IO);
        try {
            Location logRecid = new Location(recid);
            Location physRecid = this.logMgr.fetch(logRecid);
            byte[] data = serializer.serialize(obj);
            LOG.debug("BaseRecordManager.update() recid {} length {}", (Object)recid, (Object)data.length);
            Location newRecid = this.physMgr.update(physRecid, data, 0, data.length);
            if (!newRecid.equals(physRecid)) {
                this.logMgr.update(logRecid, newRecid);
            }
        }
        finally {
            this.endIO(recid, element, IOType.WRITE_IO);
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fetch(long recid, Serializer serializer) throws IOException {
        Object result;
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        LockElement element = this.beginIO(recid, IOType.READ_IO);
        try {
            Location location = this.logMgr.fetch(new Location(recid));
            byte[] data = this.physMgr.fetch(location);
            LOG.debug("BaseRecordManager.fetch() recid {} length {}", (Object)recid, (Object)data.length);
            result = serializer.deserialize(data);
        }
        finally {
            this.endIO(recid, element, IOType.READ_IO);
        }
        return result;
    }

    @Override
    public int getRootCount() {
        return 501;
    }

    @Override
    public long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this.pageMgr.getFileHeader().getRoot(id);
    }

    @Override
    public void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this.pageMgr.getFileHeader().setRoot(id, rowid);
    }

    @Override
    public long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        Long recid = nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    @Override
    public void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        if (recid == 0L) {
            this.getNameDirectory().remove(name);
        } else {
            this.getNameDirectory().put(name, recid);
        }
        this.saveNameDirectory();
    }

    @Override
    public void commit() throws IOException {
        this.checkIfClosed();
        this.pageMgr.commit();
    }

    @Override
    public void rollback() throws IOException {
        this.checkIfClosed();
        this.pageMgr.rollback();
    }

    private Map<String, Long> getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this.nameDirectory = new HashMap<String, Long>();
            nameDirectory_recid = this.insert(this.nameDirectory);
            this.setRoot(0, nameDirectory_recid);
        } else {
            this.nameDirectory = (Map)this.fetch(nameDirectory_recid);
        }
        return this.nameDirectory;
    }

    private void saveNameDirectory() throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new IOException(I18n.err((I18n)I18n.ERR_537, (Object[])new Object[0]));
        }
        this.update(recid, this.nameDirectory);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this.recordFile == null) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_538, (Object[])new Object[0]));
        }
    }

    private LockElement beginIO(Long recid, IOType io) {
        boolean lockVerified = false;
        LockElement element = null;
        return element;
    }

    private void endIO(Long recid, LockElement element, IOType io) {
    }

    private boolean conflictingIOPredicate(IOType io, LockElement element) {
        if (io == IOType.READ_IO) {
            return element.beingWritten();
        }
        return element.anyReaders() || element.beingWritten();
    }

    private static class LockElement {
        private int readers;
        private int waiters;
        private boolean writer;
        private Lock lock = new ReentrantLock();
        private Condition cv = this.lock.newCondition();

        private LockElement() {
        }

        public boolean anyReaders() {
            return this.readers > 0;
        }

        public boolean anyWaiters() {
            return this.waiters > 0;
        }

        public boolean beingWritten() {
            return this.writer;
        }

        public boolean anyUser() {
            return this.readers > 0 || this.waiters > 0 || this.writer;
        }

        public void bumpReaders() {
            ++this.readers;
        }

        public void decrementReaders() {
            --this.readers;
        }

        public void bumpWaiters() {
            ++this.waiters;
        }

        public void decrementWaiters() {
            --this.waiters;
        }

        public void setWritten() {
            this.writer = true;
        }

        public void unsetWritten() {
            this.writer = false;
        }

        public Lock getLock() {
            return this.lock;
        }

        public Condition getNoConflictingIOCondition() {
            return this.cv;
        }
    }

    private static enum IOType {
        READ_IO,
        WRITE_IO;

    }
}

