/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.control.util;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.ad.control.DirSyncControl;
import org.ldaptive.ad.control.ExtendedDnControl;
import org.ldaptive.ad.control.ShowDeletedControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.DefaultCookieManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirSyncClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final DirSyncControl.Flag[] dirSyncFlags;
    private final int maxAttributeCount;
    private ExtendedDnControl.Flag extendedDnFlag = ExtendedDnControl.Flag.STANDARD;

    public DirSyncClient(Connection conn) {
        this(conn, null, 0);
    }

    public DirSyncClient(Connection conn, DirSyncControl.Flag[] dsFlags) {
        this(conn, dsFlags, 0);
    }

    public DirSyncClient(Connection conn, DirSyncControl.Flag[] dsFlags, int count) {
        this.connection = conn;
        this.dirSyncFlags = dsFlags;
        this.maxAttributeCount = count;
    }

    public ExtendedDnControl.Flag getExtendedDnFlag() {
        return this.extendedDnFlag;
    }

    public void setExtendedDnFlag(ExtendedDnControl.Flag flag) {
        this.extendedDnFlag = flag;
    }

    public Response<SearchResult> execute(SearchRequest request) throws LdapException {
        return this.execute(request, new DefaultCookieManager());
    }

    public Response<SearchResult> execute(SearchRequest request, Response<SearchResult> response) throws LdapException {
        byte[] cookie = this.getDirSyncCookie(response);
        if (cookie == null) {
            throw new IllegalArgumentException("Response does not contain a dir sync cookie");
        }
        return this.execute(request, new DefaultCookieManager(cookie));
    }

    public Response<SearchResult> execute(SearchRequest request, CookieManager manager) throws LdapException {
        SearchOperation search = new SearchOperation(this.connection);
        request.setControls(this.createRequestControls(manager.readCookie()));
        Response<SearchResult> response = search.execute(request);
        byte[] cookie = this.getDirSyncCookie(response);
        if (cookie != null) {
            manager.writeCookie(cookie);
        }
        return response;
    }

    public boolean hasMore(Response<SearchResult> response) {
        return this.getDirSyncFlags(response) != 0L;
    }

    public Response<SearchResult> executeToCompletion(SearchRequest request) throws LdapException {
        return this.executeToCompletion(request, new DefaultCookieManager());
    }

    public Response<SearchResult> executeToCompletion(SearchRequest request, CookieManager manager) throws LdapException {
        long flags;
        Response<SearchResult> response = null;
        SearchResult result = new SearchResult();
        SearchOperation search = new SearchOperation(this.connection);
        byte[] cookie = manager.readCookie();
        do {
            if (response != null && response.getResult() != null) {
                result.addEntries(((SearchResult)response.getResult()).getEntries());
                result.addReferences(((SearchResult)response.getResult()).getReferences());
            }
            request.setControls(this.createRequestControls(cookie));
            response = search.execute(request);
            flags = this.getDirSyncFlags(response);
            cookie = this.getDirSyncCookie(response);
            if (cookie == null) continue;
            manager.writeCookie(cookie);
        } while (flags != 0L);
        response.getResult().addEntries(result.getEntries());
        response.getResult().addReferences(result.getReferences());
        return response;
    }

    protected long getDirSyncFlags(Response<SearchResult> response) {
        long flags = -1L;
        DirSyncControl ctl = (DirSyncControl)response.getControl("1.2.840.113556.1.4.841");
        if (ctl != null) {
            flags = ctl.getFlags();
        }
        return flags;
    }

    protected byte[] getDirSyncCookie(Response<SearchResult> response) {
        byte[] cookie = null;
        DirSyncControl ctl = (DirSyncControl)response.getControl("1.2.840.113556.1.4.841");
        if (ctl != null && ctl.getCookie() != null && ctl.getCookie().length > 0) {
            cookie = ctl.getCookie();
        }
        return cookie;
    }

    private RequestControl[] createRequestControls(byte[] cookie) {
        return new RequestControl[]{new DirSyncControl(this.dirSyncFlags, cookie, this.maxAttributeCount, true), new ExtendedDnControl(this.extendedDnFlag), new ShowDeletedControl()};
    }
}

